/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.maven.indexer;

import io.hawt.config.ConfigFacade;
import io.hawt.maven.indexer.MavenIndexerFacade;
import io.hawt.util.Strings;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncMavenIndexerFacadeFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(AsyncMavenIndexerFacadeFactory.class);
    private MavenIndexerFacade mavenIndexer;
    private boolean updateIndexOnStartup = true;
    private ObjectName objectName;
    private MBeanServer mBeanServer;
    private String repositories;
    private String indexDirectory;
    private Timer timer;
    private TimerTask task;
    private ConfigFacade config;

    public void init() {
        this.config = ConfigFacade.getSingleton();
        if (this.config.isOffline()) {
            LOG.info("MavenIndexerFacade is not in use as hawtio is in offline mode");
            return;
        }
        this.timer = new Timer("MavenIndexerFacade startup timer", true);
        this.task = new TimerTask(){

            @Override
            public void run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    LOG.debug("Starting to create the MavenIndexerFacade");
                    AsyncMavenIndexerFacadeFactory.this.createMavenIndexer();
                    LOG.debug("Completed creating the MavenIndexerFacade");
                }
                catch (Exception e) {
                    LOG.error("Failed to create the MavenIndexerFacade: " + e, (Throwable)e);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    AsyncMavenIndexerFacadeFactory.this.timer.cancel();
                }
            }
        };
        this.timer.schedule(this.task, 3000L);
        LOG.info("Started the async timer to create the MavenIndexerFacade after the application starts up");
        if (this.repositories != null) {
            LOG.debug("Using remote repositories: " + Arrays.asList(this.repositories));
        }
    }

    public void destroy() throws Exception {
        if (this.mavenIndexer != null) {
            this.mavenIndexer.destroy();
        }
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public String getIndexDirectory() {
        return this.indexDirectory;
    }

    public void setIndexDirectory(String indexDirectory) {
        this.indexDirectory = indexDirectory;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public String getRepositories() {
        return this.repositories;
    }

    public void setRepositories(String repositories) {
        this.repositories = repositories;
    }

    public boolean isUpdateIndexOnStartup() {
        return this.updateIndexOnStartup;
    }

    public void setUpdateIndexOnStartup(boolean updateIndexOnStartup) {
        this.updateIndexOnStartup = updateIndexOnStartup;
    }

    protected void createMavenIndexer() throws Exception {
        this.mavenIndexer = new MavenIndexerFacade();
        this.mavenIndexer.setUpdateIndexOnStartup(this.updateIndexOnStartup);
        if (Strings.isNotBlank((String)this.indexDirectory)) {
            this.mavenIndexer.setCacheDirName(this.indexDirectory);
        }
        if (this.objectName != null) {
            this.mavenIndexer.setObjectName(this.objectName);
        }
        if (this.mBeanServer != null) {
            this.mavenIndexer.setMBeanServer(this.mBeanServer);
        }
        if (this.repositories != null) {
            this.mavenIndexer.setRepositories(this.repositories);
        }
        this.mavenIndexer.init();
    }
}

