/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus;

import io.hawt.quarkus.HawtioConfig;
import io.vertx.core.Handler;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Objects;

public class HawtioPluginHandler
implements Handler<RoutingContext> {
    private final Map<String, HawtioConfig.PluginConfig> pluginConfigs;
    private final String jsonContent;

    public HawtioPluginHandler(Map<String, HawtioConfig.PluginConfig> pluginConfigs) {
        Objects.requireNonNull(pluginConfigs, "pluginConfigs must not be null");
        this.pluginConfigs = pluginConfigs;
        this.jsonContent = this.initContent();
    }

    private String initContent() {
        JsonArray plugins = new JsonArray();
        this.pluginConfigs.forEach((name, config) -> {
            JsonObject object = new JsonObject();
            object.put("url", (Object)config.url);
            object.put("scope", (Object)config.scope);
            object.put("module", (Object)config.module);
            config.remoteEntryFileName.ifPresent(value -> object.put("remoteEntryFileName", value));
            config.bustRemoteEntryCache.ifPresent(value -> object.put("bustRemoteEntryCache", value));
            config.pluginEntry.ifPresent(value -> object.put("pluginEntry", value));
            plugins.add((Object)object);
        });
        return Json.encode((Object)plugins);
    }

    public void handle(RoutingContext routingContext) {
        routingContext.response().putHeader("content-type", "application/json; charset=utf-8").end(this.jsonContent);
    }
}

