/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.auth;

import io.hawt.system.AuthenticateResult;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import java.util.Arrays;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

@ApplicationScoped
public class HawtioQuarkusAuthenticator {
    @Inject
    private IdentityProviderManager identityProviderManager;

    public AuthenticateResult authenticate(HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password) {
        if (Strings.isBlank((String)username) || Strings.isBlank((String)password)) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        PasswordCredential credential = new PasswordCredential(password.toCharArray());
        UsernamePasswordAuthenticationRequest authRequest = new UsernamePasswordAuthenticationRequest(username, credential);
        try {
            SecurityIdentity identity = this.identityProviderManager.authenticateBlocking((AuthenticationRequest)authRequest);
            String roleConfig = authConfiguration.getRole();
            if (!HawtioQuarkusAuthenticator.verifyRole(identity, roleConfig)) {
                return AuthenticateResult.NOT_AUTHORIZED;
            }
            return AuthenticateResult.AUTHORIZED;
        }
        catch (AuthenticationFailedException e) {
            return AuthenticateResult.NOT_AUTHORIZED;
        }
    }

    private static boolean verifyRole(SecurityIdentity identity, String roleConfig) {
        if (Strings.isBlank((String)roleConfig) || roleConfig.equals("*")) {
            return true;
        }
        String[] roles = roleConfig.split(",");
        return Arrays.stream(roles).anyMatch(identity.getRoles()::contains);
    }
}

