/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.filters;

import io.hawt.quarkus.auth.HawtioQuarkusAuthenticator;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationFilter;
import io.quarkus.arc.Arc;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioQuarkusAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuarkusAuthenticationFilter.class);
    private HawtioQuarkusAuthenticator authenticator;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authenticator = (HawtioQuarkusAuthenticator)Arc.container().instance(HawtioQuarkusAuthenticator.class, new Annotation[0]).get();
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject;
        LOG.trace("Applying {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path: {}", (Object)path);
        if (!this.authConfiguration.isEnabled() || this.authConfiguration.isKeycloakEnabled()) {
            LOG.debug("No authentication needed for path: {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session != null && AuthSessionHelpers.validate((HttpServletRequest)httpRequest, (HttpSession)session, (Subject)(subject = (Subject)session.getAttribute("subject")))) {
            chain.doFilter(request, response);
            return;
        }
        LOG.debug("Doing authentication and authorization for path: {}", (Object)path);
        AtomicReference username = new AtomicReference();
        AtomicReference password = new AtomicReference();
        Authenticator.extractAuthHeader((HttpServletRequest)httpRequest, (u, p) -> {
            username.set(u);
            password.set(p);
        });
        AuthenticateResult result = this.authenticator.authenticate(httpRequest, this.authConfiguration, (String)username.get(), (String)password.get());
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        switch (result) {
            case AUTHORIZED: {
                chain.doFilter(request, response);
                break;
            }
            case NOT_AUTHORIZED: {
                ServletHelpers.doForbidden((HttpServletResponse)httpResponse);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.authConfiguration.isNoCredentials401()) {
                    ServletHelpers.doAuthPrompt((String)this.authConfiguration.getRealm(), (HttpServletResponse)httpResponse);
                    break;
                }
                ServletHelpers.doForbidden((HttpServletResponse)httpResponse);
            }
        }
    }
}

