/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.filters;

import io.hawt.util.IOHelper;
import io.hawt.web.ServletHelpers;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioQuarkusPathFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuarkusPathFilter.class);
    private static final String FILTERED_PATH_PATTERN = "^/(?:(?!\\bjolokia\\b|auth|proxy|keycloak|css|fonts|img|js|user|oauth|static|\\.).)*";
    private static final String FILTERED_PATH_HAWTCONFIG = "/hawtconfig.json";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getRequestURI().substring("/hawtio".length());
        if (path.equals(FILTERED_PATH_HAWTCONFIG)) {
            LOG.debug("path = {} -- reading from classpath", (Object)path);
            String content = HawtioQuarkusPathFilter.loadFromHawtioStatic(path);
            if (content != null) {
                ServletHelpers.sendJSONResponse((HttpServletResponse)((HttpServletResponse)response), (String)content);
                return;
            }
        } else if (path.matches(FILTERED_PATH_PATTERN)) {
            LOG.debug("path = {} -- matched", (Object)path);
            httpRequest.getRequestDispatcher("/hawtio/index.html").forward(request, response);
            return;
        }
        LOG.debug("path = {} -- not matched", (Object)path);
        chain.doFilter(request, response);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static String loadFromHawtioStatic(String path) {
        String hawtioStaticPath = String.format("classpath:/hawtio-static%s", path);
        try (InputStream is = ServletHelpers.loadFile((String)hawtioStaticPath);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(is)));){
                LOG.debug("path = {} -- classpath resource found", (Object)hawtioStaticPath);
                string = IOHelper.readFully((BufferedReader)reader);
            }
            return string;
        }
        catch (Exception e) {
            LOG.debug("path = {} -- classpath resource not found: {}", (Object)hawtioStaticPath, (Object)e.getMessage());
            return null;
        }
    }
}

