/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.servlets;

import io.hawt.quarkus.auth.HawtioQuarkusAuthenticator;
import io.hawt.system.AuthenticateResult;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.Redirector;
import io.quarkus.arc.Arc;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioQuakusLoginServlet
extends LoginServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuakusLoginServlet.class);
    private HawtioQuarkusAuthenticator authenticator;

    public void init() {
        this.authenticator = (HawtioQuarkusAuthenticator)Arc.container().instance(HawtioQuarkusAuthenticator.class, new Annotation[0]).get();
        Redirector redirector = (Redirector)Arc.container().instance(Redirector.class, new Annotation[0]).get();
        this.setRedirector(redirector);
        super.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthSessionHelpers.clear((HttpServletRequest)request, (AuthenticationConfiguration)this.authConfiguration, (boolean)false);
        JSONObject json = ServletHelpers.readObject((BufferedReader)request.getReader());
        String username = (String)json.get("username");
        String password = (String)json.get("password");
        AuthenticateResult result = this.authenticator.authenticate(request, this.authConfiguration, username, password);
        switch (result) {
            case AUTHORIZED: {
                LOG.info("Logging in user: {}", (Object)username);
                AuthSessionHelpers.setup((HttpSession)request.getSession(true), (Subject)new Subject(), (String)username, (int)this.timeout);
                break;
            }
            case NOT_AUTHORIZED: 
            case NO_CREDENTIALS: {
                ServletHelpers.doForbidden((HttpServletResponse)response);
            }
        }
    }
}

