/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.auth;

import io.hawt.system.AuthenticateResult;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.AuthenticationThrottler;
import io.quarkus.security.AuthenticationFailedException;
import io.quarkus.security.credential.PasswordCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.UsernamePasswordAuthenticationRequest;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class HawtioQuarkusAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuarkusAuthenticator.class);
    @Inject
    private IdentityProviderManager identityProviderManager;

    public AuthenticateResult authenticate(AuthenticationConfiguration authConfiguration, String username, String password) {
        LOG.debug("Authenticate user: {}", (Object)username);
        if (Strings.isBlank((String)username) || Strings.isBlank((String)password)) {
            return AuthenticateResult.noCredentials();
        }
        Optional throttler = authConfiguration.getThrottler();
        AuthenticationThrottler.Attempt attempt = throttler.map(t -> t.attempt(username)).filter(AuthenticationThrottler.Attempt::isBlocked).orElse(null);
        if (attempt != null) {
            LOG.debug("Authentication throttled: {}", (Object)attempt);
            return AuthenticateResult.throttled((long)attempt.retryAfter());
        }
        PasswordCredential credential = new PasswordCredential(password.toCharArray());
        UsernamePasswordAuthenticationRequest authRequest = new UsernamePasswordAuthenticationRequest(username, credential);
        try {
            SecurityIdentity identity = this.identityProviderManager.authenticateBlocking((AuthenticationRequest)authRequest);
            String roleConfig = authConfiguration.getRoles();
            if (!HawtioQuarkusAuthenticator.verifyRole(identity, roleConfig)) {
                return AuthenticateResult.notAuthorized();
            }
            throttler.ifPresent(t -> t.reset(username));
            return AuthenticateResult.authorized();
        }
        catch (AuthenticationFailedException e) {
            LOG.warn("Login failed due to: {}", (Object)e.getMessage());
            throttler.ifPresent(t -> t.increase(username));
            return AuthenticateResult.notAuthorized();
        }
    }

    private static boolean verifyRole(SecurityIdentity identity, String roleConfig) {
        if (Strings.isBlank((String)roleConfig) || roleConfig.equals("*")) {
            return true;
        }
        String[] roles = roleConfig.split(",");
        return Arrays.stream(roles).anyMatch(identity.getRoles()::contains);
    }
}

