/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.filters;

import io.hawt.quarkus.auth.HawtioQuarkusAuthenticator;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ForbiddenReason;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationFilter;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioQuarkusAuthenticationFilter
extends AuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuarkusAuthenticationFilter.class);
    private InstanceHandle<HawtioQuarkusAuthenticator> handle;
    private HawtioQuarkusAuthenticator authenticator;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.handle = Arc.container().instance(HawtioQuarkusAuthenticator.class, new Annotation[0]);
        this.authenticator = (HawtioQuarkusAuthenticator)this.handle.get();
        super.init(filterConfig);
    }

    public void destroy() {
        if (this.handle != null) {
            this.handle.close();
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("OPTIONS".equals(httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path: {}", (Object)path);
        if (!this.authConfiguration.isEnabled() || this.authConfiguration.isKeycloakEnabled()) {
            LOG.debug("No authentication needed for path: {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        AuthenticationFilter.ProxyRequestType proxyMode = this.isProxyMode(httpRequest);
        if (proxyMode == AuthenticationFilter.ProxyRequestType.PROXY_ENABLED) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (proxyMode == AuthenticationFilter.ProxyRequestType.PROXY && session == null && !this.authConfiguration.isExternalAuthenticationEnabled()) {
            ServletHelpers.doForbidden((HttpServletResponse)httpResponse, (ForbiddenReason)ForbiddenReason.SESSION_EXPIRED);
            return;
        }
        if (session != null) {
            Subject subject = (Subject)session.getAttribute("subject");
            if (proxyMode == AuthenticationFilter.ProxyRequestType.PROXY) {
                if (subject != null) {
                    chain.doFilter(request, response);
                } else {
                    ServletHelpers.doForbidden((HttpServletResponse)httpResponse);
                }
                return;
            }
            if (AuthSessionHelpers.validate((HttpServletRequest)httpRequest, (HttpSession)session, (Subject)subject)) {
                chain.doFilter(request, response);
                return;
            }
        }
        LOG.debug("Doing authentication and authorization for path: {}", (Object)path);
        AtomicReference username = new AtomicReference();
        AtomicReference password = new AtomicReference();
        Authenticator.extractAuthHeader((HttpServletRequest)httpRequest, (u, p) -> {
            username.set(u);
            password.set(p);
        });
        AuthenticateResult result = this.authenticator.authenticate(this.authConfiguration, (String)username.get(), (String)password.get());
        switch (result.getType()) {
            case AUTHORIZED: {
                chain.doFilter(request, response);
                break;
            }
            case NOT_AUTHORIZED: {
                ServletHelpers.doForbidden((HttpServletResponse)httpResponse);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.authConfiguration.isNoCredentials401()) {
                    ServletHelpers.doAuthPrompt((HttpServletResponse)httpResponse, (String)this.authConfiguration.getRealm());
                    break;
                }
                ServletHelpers.doForbidden((HttpServletResponse)httpResponse);
                break;
            }
            case THROTTLED: {
                ServletHelpers.doTooManyRequests((HttpServletResponse)httpResponse, (long)result.getRetryAfter());
            }
        }
    }
}

