/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.quarkus.servlets;

import io.hawt.quarkus.auth.HawtioQuarkusAuthenticator;
import io.hawt.system.AuthenticateResult;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.Redirector;
import io.quarkus.arc.Arc;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.security.auth.Subject;
import org.jolokia.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawtioQuakusLoginServlet
extends LoginServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HawtioQuakusLoginServlet.class);
    private HawtioQuarkusAuthenticator authenticator;

    public void init() {
        this.authenticator = (HawtioQuarkusAuthenticator)Arc.container().instance(HawtioQuarkusAuthenticator.class, new Annotation[0]).get();
        Redirector redirector = (Redirector)Arc.container().instance(Redirector.class, new Annotation[0]).get();
        this.setRedirector(redirector);
        super.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthSessionHelpers.clear((HttpServletRequest)request, (AuthenticationConfiguration)this.authConfiguration, (boolean)false);
        JSONObject json = ServletHelpers.readObject((BufferedReader)request.getReader());
        String username = (String)json.get((Object)"username");
        String password = (String)json.get((Object)"password");
        AuthenticateResult result = this.authenticator.authenticate(this.authConfiguration, username, password);
        switch (result.getType()) {
            case AUTHORIZED: {
                LOG.info("Logging in user: {}", (Object)username);
                AuthSessionHelpers.setup((HttpSession)request.getSession(true), (Subject)new Subject(), (String)username, (int)this.timeout);
                break;
            }
            case NOT_AUTHORIZED: 
            case NO_CREDENTIALS: {
                ServletHelpers.doForbidden((HttpServletResponse)response);
                break;
            }
            case THROTTLED: {
                ServletHelpers.doTooManyRequests((HttpServletResponse)response, (long)result.getRetryAfter());
            }
        }
    }
}

