/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.HawtioProperties;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnWebApplication
@PropertySource(value={"classpath:/io/hawt/springboot/application.properties"})
@EnableConfigurationProperties
public class HawtioEndpointAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public HawtioEndpoint hawtioEndpoint(EndpointPathResolver endpointPathResolver) {
        return new HawtioEndpoint(endpointPathResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HawtioEndpoint.class})
    public EndpointPathResolver hawtioEndpointPathResolver(WebEndpointProperties webEndpointProperties, ServerProperties serverProperties, ManagementServerProperties managementServerProperties, DispatcherServletPath dispatcherServletPath) {
        return new EndpointPathResolver(webEndpointProperties, serverProperties, managementServerProperties, dispatcherServletPath);
    }

    @Bean
    @ConditionalOnBean(value={HawtioEndpoint.class})
    @ConfigurationProperties
    protected HawtioConfigurationProperties hawtioConfigurationProperties() {
        return new HawtioConfigurationProperties();
    }

    @Bean
    @ConditionalOnBean(value={HawtioConfigurationProperties.class})
    public HawtioProperties hawtioProperties(HawtioConfigurationProperties hawtioConfigurationProperties) {
        return new HawtioProperties(hawtioConfigurationProperties.getHawtio());
    }

    private static class HawtioConfigurationProperties {
        private final Map<String, String> hawtio = new HashMap<String, String>();

        private HawtioConfigurationProperties() {
        }

        public Map<String, String> getHawtio() {
            return this.hawtio;
        }
    }
}

