/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.web.auth.Redirector;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrailingSlashFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(TrailingSlashFilter.class);
    private final Redirector redirector;

    public TrailingSlashFilter(Redirector redirector) {
        this.redirector = redirector;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (!httpRequest.getRequestURI().endsWith("/")) {
            filterChain.doFilter(request, response);
            return;
        }
        this.redirector.doRedirect(httpRequest, httpResponse, "/index.html");
    }
}

