/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthInfo;
import io.hawt.system.Authenticator;
import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.util.GregorianCalendar;
import javax.security.auth.Subject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthSessionHelpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthSessionHelpers.class);
    public static final int DEFAULT_SESSION_TIMEOUT = 1800;

    private AuthSessionHelpers() {
    }

    public static int getSessionTimeout(ServletContext context) {
        int timeout = 1800;
        ConfigManager configManager = (ConfigManager)context.getAttribute("ConfigManager");
        if (configManager == null) {
            return timeout;
        }
        String timeoutStr = configManager.get("sessionTimeout", Integer.toString(1800));
        if (timeoutStr == null) {
            return timeout;
        }
        try {
            timeout = Integer.parseInt(timeoutStr);
            if (timeout == 0) {
                timeout = 1800;
            }
        }
        catch (Exception e) {
            timeout = 1800;
        }
        return timeout;
    }

    public static void clear(HttpServletRequest request, AuthenticationConfiguration authConfig, boolean authenticatorLogout) {
        HttpSession session = request.getSession(false);
        if (!AuthSessionHelpers.isAuthenticated(session)) {
            return;
        }
        Subject subject = (Subject)session.getAttribute("subject");
        LOG.info("Logging out existing user: {}", session.getAttribute("user"));
        if (authenticatorLogout) {
            Authenticator.logout(authConfig, subject);
        }
        session.invalidate();
    }

    public static void setup(HttpSession session, Subject subject, String username, int timeout) {
        session.setAttribute("subject", (Object)subject);
        session.setAttribute("user", (Object)username);
        session.setAttribute("org.osgi.service.http.authentication.remote.user", (Object)username);
        session.setAttribute("org.osgi.service.http.authentication.type", (Object)"BASIC");
        session.setAttribute("loginTime", (Object)GregorianCalendar.getInstance().getTimeInMillis());
        session.setMaxInactiveInterval(timeout);
        LOG.debug("Http session timeout for user {} is {} sec.", (Object)username, (Object)session.getMaxInactiveInterval());
    }

    public static boolean validate(HttpServletRequest request, HttpSession session, Subject subject) {
        if (session == null || subject == null) {
            return false;
        }
        AuthInfo info = Authenticator.getAuthorizationHeader(request);
        String sessionUser = (String)session.getAttribute("user");
        if (info.username == null || info.username.equals(sessionUser)) {
            LOG.debug("Session subject - {}", (Object)subject);
            return true;
        }
        LOG.debug("User differs, re-authenticating: {} (request) != {} (session)", (Object)info.username, (Object)sessionUser);
        session.invalidate();
        return false;
    }

    public static boolean isAuthenticated(HttpSession session) {
        return session != null && session.getAttribute("subject") != null;
    }

    public static boolean isSpringSecurityEnabled() {
        try {
            Class.forName("org.springframework.security.core.SpringSecurityCoreVersion");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

