/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.kubernetes;

import java.lang.management.ManagementFactory;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResolver {
    private static final transient Logger LOG = LoggerFactory.getLogger(ServiceResolver.class);
    public static ServiceResolver singleton = new ServiceResolver();
    public static ObjectName OBJECT_NAME;

    public static ServiceResolver getSingleton() {
        return singleton;
    }

    public String getServiceURL(String serviceName) {
        ObjectName objectName = OBJECT_NAME;
        String operationName = "getServiceUrl";
        Object[] params = new Object[]{serviceName};
        String[] types = new String[]{String.class.getName()};
        Object answer = ServiceResolver.invokeMBeanOperation(objectName, operationName, params, types);
        return answer != null ? answer.toString() : null;
    }

    public String getPodUrl(String podName, String port) {
        ObjectName objectName = OBJECT_NAME;
        String operationName = "getPodUrl";
        Object[] params = new Object[]{podName, port};
        String[] types = new String[]{String.class.getName(), String.class.getName()};
        Object answer = ServiceResolver.invokeMBeanOperation(objectName, operationName, params, types);
        return answer != null ? answer.toString() : null;
    }

    protected static Object invokeMBeanOperation(ObjectName objectName, String operationName, Object[] params, String[] types) {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Object answer = null;
        if (mBeanServer != null && mBeanServer.isRegistered(objectName)) {
            try {
                answer = mBeanServer.invoke(objectName, operationName, params, types);
            }
            catch (Exception e) {
                LOG.warn("Could not invoke: " + operationName + Arrays.asList(params) + " on " + objectName + ". " + e, (Throwable)e);
            }
        }
        return answer;
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=KubernetesManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

