/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AuthenticateResult;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.karaf.jaas.boot.principal.ClientPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator {
    private static final transient Logger LOG = LoggerFactory.getLogger(Authenticator.class);
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    public static final String ATTRIBUTE_X509_CERTIFICATE = "javax.servlet.request.X509Certificate";
    private static Boolean websphereDetected;
    private static Method websphereGetGroupsMethod;
    private static Boolean jbosseapDetected;
    private static Method jbosseapGetGroupsMethod;
    private final HttpServletRequest request;
    private final AuthenticationConfiguration authConfiguration;
    private String username;
    private String password;
    private java.security.cert.X509Certificate[] certificates;

    public Authenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password) {
        this.request = request;
        this.authConfiguration = authConfiguration;
        this.username = username;
        this.password = password;
    }

    public Authenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration) {
        this.request = request;
        this.authConfiguration = authConfiguration;
        Authenticator.extractAuthHeader(request, (username, password) -> {
            this.username = username;
            this.password = password;
        });
        Object certificates = request.getAttribute(ATTRIBUTE_X509_CERTIFICATE);
        if (certificates != null) {
            this.certificates = (java.security.cert.X509Certificate[])certificates;
        }
    }

    public static void extractAuthHeader(HttpServletRequest request, BiConsumer<String, String> callback) {
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (Strings.isBlank((String)authHeader)) {
            return;
        }
        String[] parts = authHeader.trim().split(" ");
        if (parts.length != 2) {
            return;
        }
        String authType = parts[0];
        String authInfo = parts[1];
        if (authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            String decoded = new String(Base64.decodeBase64((String)authInfo));
            int delimiter = decoded.indexOf(58);
            if (delimiter < 0) {
                return;
            }
            String username = decoded.substring(0, delimiter);
            String password = decoded.substring(delimiter + 1);
            callback.accept(username, password);
        }
    }

    public boolean isUsernamePasswordSet() {
        return Strings.isNotBlank((String)this.username) && Strings.isNotBlank((String)this.password);
    }

    public boolean hasNoCredentials() {
        return (!this.isUsernamePasswordSet() || this.username.equals("public")) && this.certificates == null;
    }

    public static void logout(AuthenticationConfiguration authConfiguration, Subject subject) {
        try {
            LoginContext loginContext = new LoginContext(authConfiguration.getRealm(), subject);
            loginContext.logout();
        }
        catch (Exception e) {
            LOG.warn("Error occurred while logging out", (Throwable)e);
        }
    }

    public AuthenticateResult authenticate(Consumer<Subject> callback) {
        if (this.hasNoCredentials()) {
            return AuthenticateResult.NO_CREDENTIALS;
        }
        Subject subject = this.doAuthenticate();
        if (subject == null) {
            return AuthenticateResult.NOT_AUTHORIZED;
        }
        if (callback != null) {
            try {
                callback.accept(subject);
            }
            catch (Exception e) {
                LOG.warn("Failed to execute privileged action:", (Throwable)e);
            }
        }
        return AuthenticateResult.AUTHORIZED;
    }

    protected Subject doAuthenticate() {
        String realm = this.authConfiguration.getRealm();
        String role = this.authConfiguration.getRole();
        String rolePrincipalClasses = this.authConfiguration.getRolePrincipalClasses();
        Configuration configuration = this.authConfiguration.getConfiguration();
        try {
            LOG.debug("doAuthenticate[realm={}, role={}, rolePrincipalClasses={}, configuration={}, username={}, password={}]", new Object[]{realm, role, rolePrincipalClasses, configuration, this.username, "******"});
            Subject subject = this.initSubject();
            this.login(subject, realm, configuration);
            if (this.checkRoles(subject, role, rolePrincipalClasses)) {
                return subject;
            }
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.warn("Login failed due to: {}", (Object)e.getMessage());
            LOG.debug("Failed stacktrace:", (Throwable)e);
        }
        return null;
    }

    protected Subject initSubject() {
        Subject subject = new Subject();
        try {
            String addr = this.request.getRemoteHost() + ":" + this.request.getRemotePort();
            subject.getPrincipals().add((Principal)new ClientPrincipal("hawtio", addr));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return subject;
    }

    protected void login(Subject subject, String realm, Configuration configuration) throws LoginException {
        CallbackHandler handler = this.createCallbackHandler();
        LoginContext loginContext = configuration != null ? new LoginContext(realm, subject, handler, configuration) : new LoginContext(realm, subject, handler);
        loginContext.login();
    }

    private CallbackHandler createCallbackHandler() {
        if (this.isUsernamePasswordSet()) {
            return new UsernamePasswordCallbackHandler(this.username, this.password);
        }
        return new CertificateCallbackHandler(this.certificates);
    }

    protected boolean checkRoles(Subject subject, String role, String rolePrincipalClasses) {
        boolean found;
        if (Strings.isBlank((String)role)) {
            LOG.debug("Skipping role check, no role configured");
            return true;
        }
        if (role.equals("*")) {
            LOG.debug("Skipping role check, all roles allowed");
            return true;
        }
        if (Authenticator.isRunningOnWebsphere(subject)) {
            found = Authenticator.checkIfSubjectHasRequiredRoleOnWebsphere(subject, role);
        } else if (Authenticator.isRunningOnJbossEAP(subject)) {
            found = Authenticator.checkIfSubjectHasRequiredRoleOnJbossEAP(subject, role);
        } else {
            if (Strings.isBlank((String)rolePrincipalClasses)) {
                LOG.debug("Skipping role check, no rolePrincipalClasses configured");
                return true;
            }
            found = this.checkIfSubjectHasRequiredRole(subject, role, rolePrincipalClasses);
        }
        if (!found) {
            LOG.debug("User {} does not have the required role {}", (Object)this.username, (Object)role);
        }
        return found;
    }

    private boolean checkIfSubjectHasRequiredRole(Subject subject, String role, String rolePrincipalClasses) {
        String[] roleArray = role.split(",");
        String[] rolePrincipalClazzes = rolePrincipalClasses.split(",");
        boolean found = false;
        for (String clazz : rolePrincipalClazzes) {
            LOG.debug("Looking for rolePrincipalClass: {}", (Object)clazz);
            for (Principal p : subject.getPrincipals()) {
                LOG.debug("Checking principal, classname: {} toString: {}", (Object)p.getClass().getName(), (Object)p);
                if (!p.getClass().getName().equals(clazz.trim())) {
                    LOG.debug("principal class {} doesn't match {}, continuing", (Object)p.getClass().getName(), (Object)clazz.trim());
                    continue;
                }
                for (String r : roleArray) {
                    if (r != null && p.getName().equals(r.trim())) {
                        LOG.debug("Matched role and role principal class");
                        found = true;
                        break;
                    }
                    LOG.debug("role {} doesn't match {}, continuing", (Object)p.getName(), (Object)r);
                }
                if (!found) continue;
                break;
            }
            if (found) break;
        }
        return found;
    }

    private static boolean isRunningOnWebsphere(Subject subject) {
        if (websphereDetected == null) {
            boolean onWebsphere = false;
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Checking principal for IBM specific interfaces: {}", (Object)p);
                onWebsphere = Authenticator.implementsInterface(p, "com.ibm.websphere.security.auth.WSPrincipal");
            }
            LOG.trace("Checking if we are running using a IBM Websphere specific LoginModule: {}", (Object)onWebsphere);
            websphereDetected = onWebsphere;
        }
        return websphereDetected;
    }

    private static boolean isRunningOnJbossEAP(Subject subject) {
        if (jbosseapDetected == null) {
            boolean onJbossEAP = false;
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Checking principal for JBoss EAP specific interfaces: {} {}", (Object)p, (Object)p.getClass().getName());
                onJbossEAP = "org.jboss.security.SimplePrincipal".equals(p.getClass().getName());
                if (!onJbossEAP) continue;
                break;
            }
            LOG.trace("Checking if we are running using a Jboss EAP specific LoginModule: {}", (Object)onJbossEAP);
            jbosseapDetected = onJbossEAP;
        }
        return jbosseapDetected;
    }

    private static boolean checkIfSubjectHasRequiredRoleOnWebsphere(Subject subject, String role) {
        LOG.debug("Running on websphere: checking if the Role {} is in the set of groups in WSCredential", (Object)role);
        for (Object cred : subject.getPublicCredentials()) {
            LOG.debug("Checking credential {} if it is a WebSphere specific WSCredential containing group info", cred);
            if (!Authenticator.implementsInterface(cred, "com.ibm.websphere.security.cred.WSCredential")) continue;
            try {
                Method groupsMethod = Authenticator.getWebSphereGetGroupsMethod(cred);
                List groups = (List)groupsMethod.invoke(cred, new Object[0]);
                if (groups != null) {
                    LOG.debug("Found a total of {} groups in the IBM WebSphere Credentials", (Object)groups.size());
                    for (Object group : groups) {
                        String[] roleArray;
                        LOG.debug("Matching IBM Websphere group name {} to required role {}", group, (Object)role);
                        for (String r : roleArray = role.split(",")) {
                            if (r.equals(group.toString())) {
                                LOG.debug("Required role {} found in IBM WebSphere specific credentials", (Object)r);
                                return true;
                            }
                            LOG.debug("role {} doesn't match {}, continuing", (Object)r, (Object)group.toString());
                        }
                    }
                    continue;
                }
                LOG.debug("The IBM Websphere groups list is null");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("Caught exception trying to read groups from WebSphere specific WSCredentials class", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean checkIfSubjectHasRequiredRoleOnJbossEAP(Subject subject, String role) {
        LOG.debug("Running on Jboss EAP: checking if the Role {} is in the set of groups in SimpleGroup", (Object)role);
        for (Principal prin : subject.getPrincipals()) {
            LOG.debug("Checking principal {} if it is a Jboss specific SimpleGroup containing group info", (Object)prin);
            if (!"org.jboss.security.SimpleGroup".equals(prin.getClass().getName()) || !"Roles".equals(prin.getName())) continue;
            try {
                Method groupsMethod = Authenticator.getJbossEAPGetGroupsMethod(prin);
                Enumeration groups = (Enumeration)groupsMethod.invoke((Object)prin, new Object[0]);
                if (groups != null) {
                    while (groups.hasMoreElements()) {
                        String[] roleArray;
                        Principal group = (Principal)groups.nextElement();
                        LOG.debug("Matching Jboss EAP group name {} to required role(s) {}", (Object)group, (Object)role);
                        for (String r : roleArray = role.split(",")) {
                            if (r.equals(group.toString())) {
                                LOG.debug("Required role {} found in Jboss EAP specific credentials", (Object)r);
                                return true;
                            }
                            LOG.debug("role {} doesn't match {}, continuing", (Object)r, (Object)group.toString());
                        }
                    }
                    continue;
                }
                LOG.debug("The Jboss EAP groups list is null");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("Caught exception trying to read groups from JBoss EAP specific SimpleGroup class", (Throwable)e);
            }
        }
        return false;
    }

    private static Method getWebSphereGetGroupsMethod(Object cred) throws NoSuchMethodException {
        if (websphereGetGroupsMethod == null) {
            websphereGetGroupsMethod = cred.getClass().getMethod("getGroupIds", new Class[0]);
        }
        return websphereGetGroupsMethod;
    }

    private static Method getJbossEAPGetGroupsMethod(Object cred) throws NoSuchMethodException {
        if (jbosseapGetGroupsMethod == null) {
            jbosseapGetGroupsMethod = cred.getClass().getMethod("members", new Class[0]);
        }
        return jbosseapGetGroupsMethod;
    }

    private static boolean implementsInterface(Object o, String interfaceName) {
        boolean implementsIf = false;
        for (Class<?> pif : o.getClass().getInterfaces()) {
            LOG.trace("Checking interface {} if it matches {}", pif, (Object)interfaceName);
            if (!pif.getName().equals(interfaceName)) continue;
            implementsIf = true;
            break;
        }
        return implementsIf;
    }

    private static final class CertificateCallbackHandler
    implements CallbackHandler {
        private static final String ARTEMIS_CALLBACK = "org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback";
        private static final String ARTEMIS_CALLBACK_METHOD = "setCertificates";
        private final java.security.cert.X509Certificate[] certificates;

        private CertificateCallbackHandler(java.security.cert.X509Certificate[] certificates) {
            this.certificates = certificates;
        }

        @Override
        public void handle(Callback[] callbacks) {
            block6: for (Callback callback : callbacks) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Callback type {} -> {}", callback.getClass(), (Object)callback);
                }
                switch (callback.getClass().getName()) {
                    case "org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback": {
                        this.setCertificates(callback);
                        continue block6;
                    }
                    default: {
                        LOG.warn("Callback class not supported: {}", (Object)callback.getClass().getName());
                    }
                }
            }
        }

        private void setCertificates(Callback callback) {
            try {
                Method method = callback.getClass().getDeclaredMethod(ARTEMIS_CALLBACK_METHOD, X509Certificate[].class);
                method.invoke((Object)callback, new Object[]{CertificateCallbackHandler.toJavax(this.certificates)});
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | CertificateEncodingException | CertificateException e) {
                LOG.error("Setting certificates to callback failed", (Throwable)e);
            }
        }

        private static X509Certificate[] toJavax(java.security.cert.X509Certificate[] certificates) throws CertificateEncodingException, CertificateException {
            ArrayList<X509Certificate> answer = new ArrayList<X509Certificate>();
            for (java.security.cert.X509Certificate cert : certificates) {
                answer.add(X509Certificate.getInstance(cert.getEncoded()));
            }
            return answer.toArray(new X509Certificate[certificates.length]);
        }
    }

    private static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        private UsernamePasswordCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Callback type {} -> {}", callback.getClass(), (Object)callback);
                }
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                LOG.debug("Unknown callback class [{}]", (Object)callback.getClass().getName());
            }
        }
    }
}

