/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Redirector {
    public static final String HAWTIO_REDIRECT_SCHEME = "hawtio.redirect.scheme";
    private String scheme = System.getProperty("hawtio.redirect.scheme");
    private String applicationContextPath = "";

    public void doRedirect(HttpServletRequest request, HttpServletResponse response, String path) throws IOException {
        String redirectUrl = "";
        if (this.scheme == null) {
            this.scheme = request.getServletContext().getInitParameter("scheme");
        }
        if (this.scheme != null) {
            redirectUrl = this.scheme + "://" + request.getServerName() + ":" + request.getServerPort();
        }
        redirectUrl = redirectUrl + request.getContextPath() + this.applicationContextPath + path;
        response.sendRedirect(redirectUrl);
    }

    public void doForward(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        request.getRequestDispatcher(this.applicationContextPath + path).forward((ServletRequest)request, (ServletResponse)response);
    }

    public void setApplicationContextPath(String applicationContextPath) {
        this.applicationContextPath = applicationContextPath;
    }
}

