/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class FlightRecordingDownloadFacade
implements Filter {
    private static final Pattern recordingPattern = Pattern.compile(".*exec/jdk.management.jfr:type=FlightRecorder/(downloadRecording\\(long\\)/)(\\d+).*");

    private static boolean isFlightRecordingRequest(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            if (!req.getMethod().equalsIgnoreCase("GET")) {
                return false;
            }
            return recordingPattern.matcher(req.getRequestURI()).find();
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (FlightRecordingDownloadFacade.isFlightRecordingRequest(request)) {
            this.downloadFlightRecording(request, response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void downloadFlightRecording(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        Matcher matcher = recordingPattern.matcher(req.getRequestURI());
        if (!matcher.find()) {
            throw new ServletException("Unable to find flightrecorder information in URL " + req.getRequestURI());
        }
        String recordingNumber = matcher.group(2);
        String replacementPattern = matcher.group(1) + recordingNumber;
        long stream = this.openStream((HttpServletResponse)response, chain, req, recordingNumber, replacementPattern);
        ((HttpServletResponse)response).setHeader("Content-Disposition", "attachment; filename=\"recording" + recordingNumber + ".jfr\"");
        BufferedOutputStream destination = new BufferedOutputStream((OutputStream)response.getOutputStream());
        while (this.readData((HttpServletResponse)response, chain, req, replacementPattern, stream, destination)) {
        }
        try {
            chain.doFilter((ServletRequest)new StandinRequest(req, replacementPattern, "closeStream(long)/" + stream), (ServletResponse)new DerivedResponse((HttpServletResponse)response));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean readData(HttpServletResponse response, FilterChain chain, HttpServletRequest req, String replacementPattern, long stream, OutputStream destination) throws IOException, ServletException {
        DerivedResponse readResponse = new DerivedResponse(response);
        chain.doFilter((ServletRequest)new StandinRequest(req, replacementPattern, "readStream(long)/" + stream), (ServletResponse)readResponse);
        Object data = readResponse.interpretResponse();
        if (data == null) {
            destination.flush();
            return false;
        }
        if (!(data instanceof JSONArray)) {
            throw new ServletException("Response did not contain expected data");
        }
        for (Number number : (Collection)data) {
            destination.write(number.byteValue());
        }
        return true;
    }

    private long openStream(HttpServletResponse response, FilterChain chain, HttpServletRequest req, String recordingNumber, String replacementPattern) throws IOException, ServletException {
        DerivedResponse openResponse = new DerivedResponse(response);
        chain.doFilter((ServletRequest)new StandinRequest(req, replacementPattern, "openStream(long,javax.management.openmbean.TabularData)/" + recordingNumber + "/" + this.emptyMapArgument(req)), (ServletResponse)openResponse);
        Object streamRef = openResponse.interpretResponse();
        if (!(streamRef instanceof Number)) {
            throw new ServletException("Response did not contain stream reference");
        }
        return ((Number)streamRef).longValue();
    }

    private String emptyMapArgument(HttpServletRequest req) {
        String emptyMap = "{}";
        if ("/proxy".equals(req.getServletPath())) {
            emptyMap = "%7B%7D";
        }
        return emptyMap;
    }

    public void destroy() {
    }

    static class RecordingOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream recorder = new ByteArrayOutputStream();

        RecordingOutputStream() {
        }

        public boolean isReady() {
            return true;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) {
            this.recorder.write(b);
        }

        byte[] getBytes() {
            return this.recorder.toByteArray();
        }
    }

    static class DerivedResponse
    extends HttpServletResponseWrapper {
        private final RecordingOutputStream output = new RecordingOutputStream();
        private int status;
        private String characterEncoding;

        public DerivedResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() {
            return this.output;
        }

        public void setStatus(int sc) {
            this.status = sc;
        }

        public void setBufferSize(int size) {
        }

        public void setCharacterEncoding(String charset) {
            this.characterEncoding = charset;
        }

        public void setContentLength(int len) {
        }

        public void setContentType(String type) {
        }

        Object interpretResponse() throws IOException {
            if (this.status / 100 > 2) {
                throw new IOException("Invalid response code " + this.status + " response: " + new String(this.output.getBytes()));
            }
            ByteArrayInputStream bytes = new ByteArrayInputStream(this.output.getBytes());
            InputStreamReader reader = this.characterEncoding != null ? new InputStreamReader((InputStream)bytes, this.characterEncoding) : new InputStreamReader(bytes);
            try {
                JSONObject response = (JSONObject)new JSONParser().parse((Reader)reader);
                if (!(response.get((Object)"status") instanceof Number) || ((Number)response.get((Object)"status")).intValue() != 200) {
                    throw new IOException("Invalid jolokia response code " + response.get((Object)"status") + " response: " + new String(this.output.getBytes()));
                }
                return response.get((Object)"value");
            }
            catch (ParseException e) {
                throw new IOException("Unable to parse JSON response");
            }
        }
    }

    static class StandinRequest
    extends HttpServletRequestWrapper {
        private final String replaceFrom;
        private final String replaceTo;

        public StandinRequest(HttpServletRequest request, String replaceFrom, String replaceTo) {
            super(request);
            this.replaceFrom = replaceFrom;
            this.replaceTo = replaceTo;
        }

        private String replaceInPath(String servletPath) {
            return servletPath.replace(this.replaceFrom, this.replaceTo);
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.replaceInPath(super.getRequestURL().toString()));
        }

        public String getRequestURI() {
            return this.replaceInPath(super.getRequestURI());
        }

        public String getRealPath(String path) {
            return this.replaceInPath(super.getRealPath(path));
        }

        public String getPathInfo() {
            return this.replaceInPath(super.getPathInfo());
        }

        public void setAttribute(String name, Object o) {
        }
    }
}

