/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.system.AuthenticatorFactory;
import io.hawt.system.JaasAuthenticator;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

public class AuthenticationManager {
    private static List<AuthenticatorFactory> authenticatorFactories;

    private AuthenticationManager() {
    }

    private static List<AuthenticatorFactory> getAuthenticatorFactories() {
        if (authenticatorFactories == null) {
            authenticatorFactories = new ArrayList<AuthenticatorFactory>();
            ServiceLoader.load(AuthenticatorFactory.class).forEach(factory -> authenticatorFactories.add((AuthenticatorFactory)factory));
            if (authenticatorFactories.isEmpty()) {
                authenticatorFactories.add(new DefaultAuthenticatorFactory());
            }
        }
        return authenticatorFactories;
    }

    public static AuthenticateResult authenticate(HttpServletRequest request, AuthenticationConfiguration authConfiguration, Consumer<Subject> callback) {
        Authenticator authenticator = AuthenticationManager.getAuthenticatorFactories().get(0).createAuthenticator(request, authConfiguration);
        return authenticator.authenticate(callback);
    }

    public static AuthenticateResult authenticate(HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password, Consumer<Subject> callback) {
        Authenticator authenticator = AuthenticationManager.getAuthenticatorFactories().get(0).createAuthenticator(request, authConfiguration, username, password);
        return authenticator.authenticate(callback);
    }

    public static void logout(AuthenticationConfiguration authConfiguration, Subject subject) {
        Authenticator authenticator = AuthenticationManager.getAuthenticatorFactories().get(0).createAuthenticator(null, authConfiguration, null, null);
        authenticator.logout(authConfiguration, subject);
    }

    private static class DefaultAuthenticatorFactory
    implements AuthenticatorFactory {
        private DefaultAuthenticatorFactory() {
        }

        @Override
        public Authenticator createAuthenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration) {
            return new JaasAuthenticator(request, authConfiguration);
        }

        @Override
        public Authenticator createAuthenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password) {
            return new JaasAuthenticator(request, authConfiguration, username, password);
        }
    }
}

