/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.system.AbstractAuthenticator;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasAuthenticator
extends AbstractAuthenticator {
    private static final transient Logger LOG = LoggerFactory.getLogger(JaasAuthenticator.class);
    private static Boolean websphereDetected;
    private static Method websphereGetGroupsMethod;
    private static Boolean jbosseapDetected;
    private static Method jbosseapGetGroupsMethod;

    public JaasAuthenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration, String username, String password) {
        super(LOG, request, authConfiguration, username, password);
    }

    public JaasAuthenticator(HttpServletRequest request, AuthenticationConfiguration authConfiguration) {
        super(LOG, request, authConfiguration);
    }

    @Override
    protected Subject doAuthenticate() {
        String realm = this.authConfiguration.getRealm();
        String role = this.authConfiguration.getRole();
        String rolePrincipalClasses = this.authConfiguration.getRolePrincipalClasses();
        Configuration configuration = this.authConfiguration.getConfiguration();
        try {
            LOG.debug("doAuthenticate[realm={}, role={}, rolePrincipalClasses={}, configuration={}, username={}, password={}]", new Object[]{realm, role, rolePrincipalClasses, configuration, this.username, "******"});
            Subject subject = this.initSubject();
            this.login(subject, realm, configuration);
            if (this.checkRoles(subject, role, rolePrincipalClasses)) {
                return subject;
            }
        }
        catch (AccountException e) {
            LOG.warn("Account failure", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.warn("Login failed due to: {}", (Object)e.getMessage());
            LOG.debug("Failed stacktrace:", (Throwable)e);
        }
        return null;
    }

    protected void login(Subject subject, String realm, Configuration configuration) throws LoginException {
        CallbackHandler handler = this.createCallbackHandler();
        LoginContext loginContext = configuration != null ? new LoginContext(realm, subject, handler, configuration) : new LoginContext(realm, subject, handler);
        loginContext.login();
    }

    @Override
    public void logout(AuthenticationConfiguration authConfiguration, Subject subject) {
        try {
            LoginContext loginContext = new LoginContext(authConfiguration.getRealm(), subject);
            loginContext.logout();
        }
        catch (Exception e) {
            LOG.warn("Error occurred while logging out", (Throwable)e);
        }
    }

    private CallbackHandler createCallbackHandler() {
        if (this.isUsernamePasswordSet()) {
            return new UsernamePasswordCallbackHandler(this.username, this.password);
        }
        return new CertificateCallbackHandler(this.certificates);
    }

    protected boolean checkRoles(Subject subject, String role, String rolePrincipalClasses) {
        boolean found;
        if (Strings.isBlank((String)role)) {
            LOG.debug("Skipping role check, no role configured");
            return true;
        }
        if (role.equals("*")) {
            LOG.debug("Skipping role check, all roles allowed");
            return true;
        }
        if (JaasAuthenticator.isRunningOnWebsphere(subject)) {
            found = JaasAuthenticator.checkIfSubjectHasRequiredRoleOnWebsphere(subject, role);
        } else if (JaasAuthenticator.isRunningOnJbossEAP(subject)) {
            found = JaasAuthenticator.checkIfSubjectHasRequiredRoleOnJbossEAP(subject, role);
        } else {
            if (Strings.isBlank((String)rolePrincipalClasses)) {
                LOG.debug("Skipping role check, no rolePrincipalClasses configured");
                return true;
            }
            found = this.checkIfSubjectHasRequiredRole(subject, role, rolePrincipalClasses);
        }
        if (!found) {
            LOG.debug("User {} does not have the required role {}", (Object)this.username, (Object)role);
        }
        return found;
    }

    private boolean checkIfSubjectHasRequiredRole(Subject subject, String role, String rolePrincipalClasses) {
        String[] roleArray = role.split(",");
        String[] rolePrincipalClazzes = rolePrincipalClasses.split(",");
        boolean found = false;
        for (String clazz : rolePrincipalClazzes) {
            LOG.debug("Looking for rolePrincipalClass: {}", (Object)clazz);
            for (Principal p : subject.getPrincipals()) {
                LOG.debug("Checking principal, classname: {} toString: {}", (Object)p.getClass().getName(), (Object)p);
                if (!p.getClass().getName().equals(clazz.trim())) {
                    LOG.debug("principal class {} doesn't match {}, continuing", (Object)p.getClass().getName(), (Object)clazz.trim());
                    continue;
                }
                for (String r : roleArray) {
                    if (r != null && p.getName().equals(r.trim())) {
                        LOG.debug("Matched role and role principal class");
                        found = true;
                        break;
                    }
                    LOG.debug("role {} doesn't match {}, continuing", (Object)p.getName(), (Object)r);
                }
                if (!found) continue;
                break;
            }
            if (found) break;
        }
        return found;
    }

    private static boolean isRunningOnWebsphere(Subject subject) {
        if (websphereDetected == null) {
            boolean onWebsphere = false;
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Checking principal for IBM specific interfaces: {}", (Object)p);
                onWebsphere = JaasAuthenticator.implementsInterface(p, "com.ibm.websphere.security.auth.WSPrincipal");
            }
            LOG.trace("Checking if we are running using a IBM Websphere specific LoginModule: {}", (Object)onWebsphere);
            websphereDetected = onWebsphere;
        }
        return websphereDetected;
    }

    private static boolean isRunningOnJbossEAP(Subject subject) {
        if (jbosseapDetected == null) {
            boolean onJbossEAP = false;
            for (Principal p : subject.getPrincipals()) {
                LOG.trace("Checking principal for JBoss EAP specific interfaces: {} {}", (Object)p, (Object)p.getClass().getName());
                onJbossEAP = "org.jboss.security.SimplePrincipal".equals(p.getClass().getName());
                if (!onJbossEAP) continue;
                break;
            }
            LOG.trace("Checking if we are running using a Jboss EAP specific LoginModule: {}", (Object)onJbossEAP);
            jbosseapDetected = onJbossEAP;
        }
        return jbosseapDetected;
    }

    private static boolean checkIfSubjectHasRequiredRoleOnWebsphere(Subject subject, String role) {
        LOG.debug("Running on websphere: checking if the Role {} is in the set of groups in WSCredential", (Object)role);
        for (Object cred : subject.getPublicCredentials()) {
            LOG.debug("Checking credential {} if it is a WebSphere specific WSCredential containing group info", cred);
            if (!JaasAuthenticator.implementsInterface(cred, "com.ibm.websphere.security.cred.WSCredential")) continue;
            try {
                Method groupsMethod = JaasAuthenticator.getWebSphereGetGroupsMethod(cred);
                List groups = (List)groupsMethod.invoke(cred, new Object[0]);
                if (groups != null) {
                    LOG.debug("Found a total of {} groups in the IBM WebSphere Credentials", (Object)groups.size());
                    for (Object group : groups) {
                        String[] roleArray;
                        LOG.debug("Matching IBM Websphere group name {} to required role {}", group, (Object)role);
                        for (String r : roleArray = role.split(",")) {
                            if (r.equals(group.toString())) {
                                LOG.debug("Required role {} found in IBM WebSphere specific credentials", (Object)r);
                                return true;
                            }
                            LOG.debug("role {} doesn't match {}, continuing", (Object)r, (Object)group.toString());
                        }
                    }
                    continue;
                }
                LOG.debug("The IBM Websphere groups list is null");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("Caught exception trying to read groups from WebSphere specific WSCredentials class", (Throwable)e);
            }
        }
        return false;
    }

    private static boolean checkIfSubjectHasRequiredRoleOnJbossEAP(Subject subject, String role) {
        LOG.debug("Running on Jboss EAP: checking if the Role {} is in the set of groups in SimpleGroup", (Object)role);
        for (Principal prin : subject.getPrincipals()) {
            LOG.debug("Checking principal {} if it is a Jboss specific SimpleGroup containing group info", (Object)prin);
            if (!"org.jboss.security.SimpleGroup".equals(prin.getClass().getName()) || !"Roles".equals(prin.getName())) continue;
            try {
                Method groupsMethod = JaasAuthenticator.getJbossEAPGetGroupsMethod(prin);
                Enumeration groups = (Enumeration)groupsMethod.invoke((Object)prin, new Object[0]);
                if (groups != null) {
                    while (groups.hasMoreElements()) {
                        String[] roleArray;
                        Principal group = (Principal)groups.nextElement();
                        LOG.debug("Matching Jboss EAP group name {} to required role(s) {}", (Object)group, (Object)role);
                        for (String r : roleArray = role.split(",")) {
                            if (r.equals(group.toString())) {
                                LOG.debug("Required role {} found in Jboss EAP specific credentials", (Object)r);
                                return true;
                            }
                            LOG.debug("role {} doesn't match {}, continuing", (Object)r, (Object)group.toString());
                        }
                    }
                    continue;
                }
                LOG.debug("The Jboss EAP groups list is null");
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                LOG.debug("Caught exception trying to read groups from JBoss EAP specific SimpleGroup class", (Throwable)e);
            }
        }
        return false;
    }

    private static Method getWebSphereGetGroupsMethod(Object cred) throws NoSuchMethodException {
        if (websphereGetGroupsMethod == null) {
            websphereGetGroupsMethod = cred.getClass().getMethod("getGroupIds", new Class[0]);
        }
        return websphereGetGroupsMethod;
    }

    private static Method getJbossEAPGetGroupsMethod(Object cred) throws NoSuchMethodException {
        if (jbosseapGetGroupsMethod == null) {
            jbosseapGetGroupsMethod = cred.getClass().getMethod("members", new Class[0]);
        }
        return jbosseapGetGroupsMethod;
    }

    private static boolean implementsInterface(Object o, String interfaceName) {
        boolean implementsIf = false;
        for (Class<?> pif : o.getClass().getInterfaces()) {
            LOG.trace("Checking interface {} if it matches {}", pif, (Object)interfaceName);
            if (!pif.getName().equals(interfaceName)) continue;
            implementsIf = true;
            break;
        }
        return implementsIf;
    }

    private static final class CertificateCallbackHandler
    implements CallbackHandler {
        private static final String ARTEMIS_CALLBACK = "org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback";
        private static final String ARTEMIS_CALLBACK_METHOD = "setCertificates";
        private final java.security.cert.X509Certificate[] certificates;

        private CertificateCallbackHandler(java.security.cert.X509Certificate[] certificates) {
            this.certificates = certificates;
        }

        @Override
        public void handle(Callback[] callbacks) {
            block6: for (Callback callback : callbacks) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Callback type {} -> {}", callback.getClass(), (Object)callback);
                }
                switch (callback.getClass().getName()) {
                    case "org.apache.activemq.artemis.spi.core.security.jaas.CertificateCallback": {
                        this.setCertificates(callback);
                        continue block6;
                    }
                    default: {
                        LOG.warn("Callback class not supported: {}", (Object)callback.getClass().getName());
                    }
                }
            }
        }

        private void setCertificates(Callback callback) {
            try {
                Method method = callback.getClass().getDeclaredMethod(ARTEMIS_CALLBACK_METHOD, java.security.cert.X509Certificate[].class);
                method.invoke((Object)callback, new Object[]{this.certificates});
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.warn("Setting certificates to new callback failed", (Throwable)e);
                try {
                    Method method = callback.getClass().getDeclaredMethod(ARTEMIS_CALLBACK_METHOD, X509Certificate[].class);
                    method.invoke((Object)callback, new Object[]{CertificateCallbackHandler.toJavax(this.certificates)});
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | CertificateEncodingException | CertificateException ex) {
                    LOG.error("Setting certificates to callback failed", (Throwable)ex);
                }
            }
        }

        private static X509Certificate[] toJavax(java.security.cert.X509Certificate[] certificates) throws CertificateEncodingException, CertificateException {
            ArrayList<X509Certificate> answer = new ArrayList<X509Certificate>();
            for (java.security.cert.X509Certificate cert : certificates) {
                answer.add(X509Certificate.getInstance(cert.getEncoded()));
            }
            return answer.toArray(new X509Certificate[certificates.length]);
        }
    }

    private static final class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        private UsernamePasswordCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Callback type {} -> {}", callback.getClass(), (Object)callback);
                }
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    ((PasswordCallback)callback).setPassword(this.password.toCharArray());
                    continue;
                }
                LOG.debug("Unknown callback class [{}]", (Object)callback.getClass().getName());
            }
        }
    }
}

