/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthHelpers;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.AuthenticationManager;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginRedirectFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(LoginRedirectFilter.class);
    private int timeout;
    private AuthenticationConfiguration authConfiguration;
    private final String[] unsecuredPaths;
    private Redirector redirector = new Redirector();

    public LoginRedirectFilter() {
        this(AuthenticationConfiguration.UNSECURED_PATHS);
    }

    public LoginRedirectFilter(String[] unsecuredPaths) {
        this.unsecuredPaths = unsecuredPaths;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext());
        this.timeout = AuthSessionHelpers.getSessionTimeout(filterConfig.getServletContext());
        LOG.info("Hawtio loginRedirectFilter is using {} sec. HttpSession timeout", (Object)this.timeout);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        String path = httpRequest.getServletPath();
        if (this.isRedirectRequired(session, path, httpRequest)) {
            this.redirector.doRedirect(httpRequest, httpResponse, "/auth/login");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isRedirectRequired(HttpSession session, String path, HttpServletRequest request) {
        return this.authConfiguration.isEnabled() && !this.authConfiguration.isKeycloakEnabled() && !AuthSessionHelpers.isSpringSecurityEnabled() && !AuthSessionHelpers.isAuthenticated(session) && this.isSecuredPath(path) && !this.tryAuthenticateRequest(request, session);
    }

    boolean tryAuthenticateRequest(HttpServletRequest request, HttpSession session) {
        AuthenticateResult result = AuthenticationManager.authenticate(request, this.authConfiguration, subject -> {
            String username = AuthHelpers.getUsername(subject);
            LOG.info("Logging in user: {}", (Object)username);
            AuthSessionHelpers.setup(session != null ? session : request.getSession(true), subject, username, this.timeout);
        });
        return result == AuthenticateResult.AUTHORIZED;
    }

    boolean isSecuredPath(String path) {
        return !Arrays.stream(this.unsecuredPaths).anyMatch(path::startsWith);
    }

    public void destroy() {
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

