/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthenticationContainerDiscovery;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.login.Configuration;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthenticationConfiguration.class);
    public static final String LOGIN_URL = "/auth/login";
    public static final String[] UNSECURED_PATHS = new String[]{"/auth", "/css", "/fonts", "/img", "/js", "/hawtconfig.json", "/jolokia", "/keycloak", "/oauth", "/user", "/login.html"};
    public static final String AUTHENTICATION_ENABLED = "authenticationEnabled";
    public static final String NO_CREDENTIALS_401 = "noCredentials401";
    public static final String REALM = "realm";
    public static final String ROLE = "role";
    public static final String ROLES = "roles";
    public static final String ROLE_PRINCIPAL_CLASSES = "rolePrincipalClasses";
    public static final String AUTHENTICATION_CONTAINER_DISCOVERY_CLASSES = "authenticationContainerDiscoveryClasses";
    public static final String KEYCLOAK_ENABLED = "keycloakEnabled";
    public static final String HAWTIO_AUTHENTICATION_ENABLED = "hawtio.authenticationEnabled";
    public static final String HAWTIO_NO_CREDENTIALS_401 = "hawtio.noCredentials401";
    public static final String HAWTIO_REALM = "hawtio.realm";
    public static final String HAWTIO_ROLE = "hawtio.role";
    public static final String HAWTIO_ROLES = "hawtio.roles";
    public static final String HAWTIO_ROLE_PRINCIPAL_CLASSES = "hawtio.rolePrincipalClasses";
    public static final String HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES = "hawtio.authenticationContainerDiscoveryClasses";
    public static final String HAWTIO_KEYCLOAK_ENABLED = "hawtio.keycloakEnabled";
    public static final String AUTHENTICATION_CONFIGURATION = "authenticationConfig";
    public static final String CONFIG_MANAGER = "ConfigManager";
    public static final String DEFAULT_REALM = "karaf";
    private static final String DEFAULT_KARAF_ROLES = "admin,manager,viewer";
    public static final String DEFAULT_KARAF_ROLE_PRINCIPAL_CLASSES = "org.apache.karaf.jaas.boot.principal.RolePrincipal,org.apache.karaf.jaas.modules.RolePrincipal,org.apache.karaf.jaas.boot.principal.GroupPrincipal";
    public static final String TOMCAT_AUTH_CONTAINER_DISCOVERY = "io.hawt.web.tomcat.TomcatAuthenticationContainerDiscovery";
    private boolean enabled;
    private boolean noCredentials401;
    private String realm;
    private String role;
    private String rolePrincipalClasses;
    private Configuration configuration;
    private boolean keycloakEnabled;

    public AuthenticationConfiguration(ServletContext servletContext) {
        ConfigManager config = (ConfigManager)servletContext.getAttribute(CONFIG_MANAGER);
        String defaultRolePrincipalClasses = "";
        if (System.getProperty("karaf.name") != null) {
            defaultRolePrincipalClasses = DEFAULT_KARAF_ROLE_PRINCIPAL_CLASSES;
        }
        String authDiscoveryClasses = TOMCAT_AUTH_CONTAINER_DISCOVERY;
        if (config != null) {
            this.realm = config.get(REALM, DEFAULT_REALM);
            String roles = config.get(ROLE, null);
            if (roles == null) {
                roles = config.get(ROLES, null);
            }
            if (roles == null) {
                roles = DEFAULT_KARAF_ROLES;
            }
            this.role = roles;
            this.rolePrincipalClasses = config.get(ROLE_PRINCIPAL_CLASSES, defaultRolePrincipalClasses);
            this.enabled = Boolean.parseBoolean(config.get(AUTHENTICATION_ENABLED, "true"));
            this.noCredentials401 = Boolean.parseBoolean(config.get(NO_CREDENTIALS_401, "false"));
            this.keycloakEnabled = this.enabled && Boolean.parseBoolean(config.get(KEYCLOAK_ENABLED, "false"));
            authDiscoveryClasses = config.get(AUTHENTICATION_CONTAINER_DISCOVERY_CLASSES, authDiscoveryClasses);
        }
        if (System.getProperty(HAWTIO_AUTHENTICATION_ENABLED) != null) {
            this.enabled = Boolean.getBoolean(HAWTIO_AUTHENTICATION_ENABLED);
        }
        if (System.getProperty(HAWTIO_NO_CREDENTIALS_401) != null) {
            this.noCredentials401 = Boolean.getBoolean(HAWTIO_NO_CREDENTIALS_401);
        }
        if (System.getProperty(HAWTIO_REALM) != null) {
            this.realm = System.getProperty(HAWTIO_REALM);
        }
        if (System.getProperty(HAWTIO_ROLE) != null) {
            this.role = System.getProperty(HAWTIO_ROLE);
        }
        if (System.getProperty(HAWTIO_ROLES) != null) {
            this.role = System.getProperty(HAWTIO_ROLES);
        }
        if (System.getProperty(HAWTIO_ROLE_PRINCIPAL_CLASSES) != null) {
            this.rolePrincipalClasses = System.getProperty(HAWTIO_ROLE_PRINCIPAL_CLASSES);
        }
        if (System.getProperty(HAWTIO_KEYCLOAK_ENABLED) != null) {
            boolean bl = this.keycloakEnabled = this.enabled && Boolean.getBoolean(HAWTIO_KEYCLOAK_ENABLED);
        }
        if (System.getProperty(HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES) != null) {
            authDiscoveryClasses = System.getProperty(HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES);
        }
        if (this.enabled) {
            List<AuthenticationContainerDiscovery> discoveries = AuthenticationConfiguration.getDiscoveries(authDiscoveryClasses);
            for (AuthenticationContainerDiscovery discovery : discoveries) {
                if (!discovery.canAuthenticate(this)) continue;
                LOG.info("Discovered container {} to use with hawtio authentication filter", (Object)discovery.getContainerName());
                break;
            }
        }
        if (this.enabled) {
            LOG.info("Starting hawtio authentication filter, JAAS realm: \"{}\" authorized role(s): \"{}\" role principal classes: \"{}\"", new Object[]{this.realm, this.role, this.rolePrincipalClasses});
        } else {
            LOG.info("Starting hawtio authentication filter, JAAS authentication disabled");
        }
    }

    public static AuthenticationConfiguration getConfiguration(ServletContext servletContext) {
        AuthenticationConfiguration authConfig = (AuthenticationConfiguration)servletContext.getAttribute(AUTHENTICATION_CONFIGURATION);
        if (authConfig == null) {
            authConfig = new AuthenticationConfiguration(servletContext);
            servletContext.setAttribute(AUTHENTICATION_ENABLED, (Object)authConfig.isEnabled());
            servletContext.setAttribute(AUTHENTICATION_CONFIGURATION, (Object)authConfig);
        }
        return authConfig;
    }

    private static List<AuthenticationContainerDiscovery> getDiscoveries(String authDiscoveryClasses) {
        String[] discoveryClasses;
        ArrayList<AuthenticationContainerDiscovery> discoveries = new ArrayList<AuthenticationContainerDiscovery>();
        if (authDiscoveryClasses == null || authDiscoveryClasses.trim().isEmpty()) {
            return discoveries;
        }
        for (String discoveryClass : discoveryClasses = authDiscoveryClasses.split(",")) {
            try {
                Class<?> clazz = AuthenticationConfiguration.class.getClassLoader().loadClass(discoveryClass.trim());
                AuthenticationContainerDiscovery discovery = (AuthenticationContainerDiscovery)clazz.newInstance();
                discoveries.add(discovery);
            }
            catch (Exception e) {
                LOG.warn("Couldn't instantiate discovery " + discoveryClass, (Throwable)e);
            }
        }
        return discoveries;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isNoCredentials401() {
        return this.noCredentials401;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getRole() {
        return this.role;
    }

    public String getRolePrincipalClasses() {
        return this.rolePrincipalClasses;
    }

    public void setRolePrincipalClasses(String rolePrincipalClasses) {
        this.rolePrincipalClasses = rolePrincipalClasses;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isKeycloakEnabled() {
        return this.keycloakEnabled;
    }

    public String toString() {
        return "AuthenticationConfiguration[enabled=" + this.enabled + ", noCredentials401=" + this.noCredentials401 + ", realm='" + this.realm + '\'' + ", role(s)='" + this.role + '\'' + ", rolePrincipalClasses='" + this.rolePrincipalClasses + '\'' + ", configuration=" + this.configuration + ", keycloakEnabled=" + this.keycloakEnabled + ']';
    }
}

