/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth.keycloak;

import io.hawt.system.ConfigManager;
import io.hawt.util.IOHelper;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakServlet
extends HttpServlet {
    private static final long serialVersionUID = 3464713772839013741L;
    private static final transient Logger LOG = LoggerFactory.getLogger(KeycloakServlet.class);
    public static final String KEYCLOAK_CLIENT_CONFIG = "keycloakClientConfig";
    public static final String HAWTIO_KEYCLOAK_CLIENT_CONFIG = "hawtio.keycloakClientConfig";
    private String keycloakConfig = null;
    private AuthenticationConfiguration authConfiguration;
    private boolean keycloakEnabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ConfigManager config = (ConfigManager)this.getServletContext().getAttribute("ConfigManager");
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
        this.keycloakEnabled = this.authConfiguration.isKeycloakEnabled();
        LOG.info("Keycloak integration is {}", (Object)(this.keycloakEnabled ? "enabled" : "disabled"));
        if (!this.keycloakEnabled) {
            return;
        }
        String keycloakConfigFile = config.get(KEYCLOAK_CLIENT_CONFIG, null);
        if (System.getProperty(HAWTIO_KEYCLOAK_CLIENT_CONFIG) != null) {
            keycloakConfigFile = System.getProperty(HAWTIO_KEYCLOAK_CLIENT_CONFIG);
        }
        if (keycloakConfigFile == null || keycloakConfigFile.length() == 0) {
            keycloakConfigFile = this.defaultKeycloakConfigLocation();
        }
        LOG.info("Will load keycloak config from location: {}", (Object)keycloakConfigFile);
        InputStream is = this.loadFile(keycloakConfigFile);
        if (is == null) {
            LOG.warn("Keycloak client configuration not found!");
        } else {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                String keycloakConfig = IOHelper.readFully((BufferedReader)reader);
                this.keycloakConfig = keycloakConfig.replaceAll(" ", "").replaceAll(System.lineSeparator(), "");
            }
            catch (IOException ioe) {
                LOG.warn("Couldn't read keycloak configuration file", (Throwable)ioe);
            }
            finally {
                IOHelper.close((Closeable)is, (String)"keycloakInputStream", (Logger)LOG);
            }
        }
    }

    protected String defaultKeycloakConfigLocation() {
        String karafBase = System.getProperty("karaf.base");
        if (karafBase != null) {
            return karafBase + "/etc/keycloak.json";
        }
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null) {
            return jettyHome + "/etc/keycloak.json";
        }
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome != null) {
            return tomcatHome + "/conf/keycloak.json";
        }
        String jbossHome = System.getProperty("jboss.server.config.dir");
        if (jbossHome != null) {
            return jbossHome + "/keycloak.json";
        }
        return "classpath:keycloak.json";
    }

    protected InputStream loadFile(String keycloakConfigFile) {
        if (keycloakConfigFile.startsWith("classpath:")) {
            String classPathLocation = keycloakConfigFile.substring(10);
            return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classPathLocation);
        }
        try {
            if (!keycloakConfigFile.contains(":")) {
                keycloakConfigFile = "file://" + keycloakConfigFile;
            }
            return new URL(keycloakConfigFile).openStream();
        }
        catch (Exception e) {
            LOG.warn("Couldn't find keycloak config file on location: " + keycloakConfigFile);
            LOG.debug("Couldn't find keycloak config file", (Throwable)e);
            return null;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo;
        switch (pathInfo = request.getPathInfo()) {
            case "/enabled": {
                this.renderJSONResponse(response, String.valueOf(this.keycloakEnabled));
                break;
            }
            case "/client-config": {
                if (this.keycloakConfig == null) {
                    response.sendError(404, "Keycloak client configuration not found");
                    break;
                }
                this.renderJSONResponse(response, this.keycloakConfig);
                break;
            }
            case "/validate-subject-matches": {
                String keycloakUser = request.getParameter("keycloakUser");
                if (keycloakUser == null || keycloakUser.length() == 0) {
                    LOG.warn("Parameter 'keycloakUser' not found");
                }
                boolean valid = this.validateKeycloakUser(request, keycloakUser);
                this.renderJSONResponse(response, String.valueOf(valid));
            }
        }
    }

    protected boolean validateKeycloakUser(HttpServletRequest request, String keycloakUser) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return true;
        }
        String username = (String)session.getAttribute("user");
        if (username != null && !username.equals(keycloakUser)) {
            LOG.debug("No matching username found. JAAS username: {}, keycloakUsername: {}. Invalidating session", (Object)username, (Object)keycloakUser);
            session.invalidate();
            return false;
        }
        return true;
    }

    private void renderJSONResponse(HttpServletResponse response, String text) throws ServletException, IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.println(text);
        writer.flush();
        writer.close();
    }
}

