/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.web.auth.LoginServlet;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHelpers {
    private static final transient Logger LOG = LoggerFactory.getLogger(LoginServlet.class);
    public static final List<String> KNOWN_PRINCIPALS = Arrays.asList("UserPrincipal", "KeycloakPrincipal", "JAASPrincipal", "SimplePrincipal");

    public static String getUsername(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        String username = null;
        if (principals != null) {
            for (Principal principal : principals) {
                String principalClass = principal.getClass().getSimpleName();
                if (!KNOWN_PRINCIPALS.contains(principalClass)) continue;
                username = principal.getName();
                LOG.debug("Username in principal: {}", (Object)username);
            }
        }
        return username;
    }
}

