/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import io.hawt.util.Hosts;
import io.hawt.util.Strings;
import io.hawt.web.proxy.ProxyDetails;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyWhitelist {
    private static final transient Logger LOG = LoggerFactory.getLogger(ProxyWhitelist.class);
    private static final String FABRIC_MBEAN = "io.fabric8:type=Fabric";
    protected CopyOnWriteArraySet<String> whitelist;
    protected List<Pattern> regexWhitelist;
    protected MBeanServer mBeanServer;
    protected ObjectName fabricMBean;

    public ProxyWhitelist(String whitelistStr) {
        this(whitelistStr, true);
    }

    public ProxyWhitelist(String whitelistStr, boolean probeLocal) {
        if (Strings.isBlank((String)whitelistStr)) {
            this.whitelist = new CopyOnWriteArraySet();
            this.regexWhitelist = Collections.emptyList();
        } else {
            this.whitelist = new CopyOnWriteArraySet<String>(this.filterRegex(Strings.split((String)whitelistStr, (String)",")));
            this.regexWhitelist = this.buildRegexWhitelist(Strings.split((String)whitelistStr, (String)","));
        }
        if (probeLocal) {
            LOG.info("Probing local addresses ...");
            this.initialiseWhitelist();
        } else {
            LOG.info("Probing local addresses disabled");
            this.whitelist.add("localhost");
            this.whitelist.add("127.0.0.1");
        }
        LOG.info("Initial proxy whitelist: {}", this.whitelist);
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.fabricMBean = new ObjectName(FABRIC_MBEAN);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<String> filterRegex(List<String> whitelist) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : whitelist) {
            if (element.startsWith("r:")) continue;
            result.add(element);
        }
        return result;
    }

    protected List<Pattern> buildRegexWhitelist(List<String> whitelist) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String element : whitelist) {
            if (!element.startsWith("r:")) continue;
            String regex = element.substring(2);
            patterns.add(Pattern.compile(regex));
        }
        return patterns;
    }

    protected void initialiseWhitelist() {
        Map localAddresses = Hosts.getNetworkInterfaceAddresses((boolean)true);
        for (Set addresses : localAddresses.values()) {
            for (InetAddress address : addresses) {
                this.whitelist.add(address.getHostAddress());
                this.whitelist.add(address.getHostName());
                this.whitelist.add(address.getCanonicalHostName());
            }
        }
    }

    public boolean isAllowed(ProxyDetails details) {
        if (details.isAllowed(this.whitelist)) {
            return true;
        }
        LOG.debug("Updating proxy whitelist: {}, {}", this.whitelist, (Object)details);
        if (this.update() && details.isAllowed(this.whitelist)) {
            return true;
        }
        return details.isAllowed(this.regexWhitelist);
    }

    public boolean update() {
        if (!this.mBeanServer.isRegistered(this.fabricMBean)) {
            LOG.debug("Whitelist MBean not available");
            return false;
        }
        Set<String> newWhitelist = this.invokeMBean();
        int previousSize = this.whitelist.size();
        this.whitelist.addAll(newWhitelist);
        if (this.whitelist.size() == previousSize) {
            LOG.debug("No new proxy whitelist to update");
            return false;
        }
        LOG.info("Updated proxy whitelist: {}", this.whitelist);
        return true;
    }

    protected Set<String> invokeMBean() {
        HashSet<String> list = new HashSet<String>();
        try {
            List containers = (List)this.mBeanServer.invoke(this.fabricMBean, "containers", new Object[]{Arrays.asList("localHostname", "localIp", "manualIp", "publicHostname", "publicIp")}, new String[]{List.class.getName()});
            LOG.debug("Returned containers from MBean: {}", (Object)containers);
            for (Map container : containers) {
                for (Object value : container.values()) {
                    if (value == null || !Strings.isNotBlank((String)value.toString())) continue;
                    list.add(value.toString());
                }
            }
            LOG.debug("Extracted whitelist: {}", list);
        }
        catch (InstanceNotFoundException | MBeanException | ReflectionException e) {
            LOG.error("Invocation to whitelist MBean failed: " + e.getMessage(), (Throwable)e);
        }
        return list;
    }
}

