/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthInfo;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private AuthenticationConfiguration authConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Subject subject2;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path {}", (Object)path);
        if (this.authConfiguration.getRealm() == null || this.authConfiguration.getRealm().equals("") || !this.authConfiguration.isEnabled()) {
            LOG.debug("No authentication needed for path {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session != null && (subject2 = (Subject)session.getAttribute("subject")) != null && this.validateSession(httpRequest, session, subject2)) {
            AuthenticationFilter.executeAs(request, response, chain, subject2);
            return;
        }
        LOG.debug("Doing authentication and authorization for path {}", (Object)path);
        AuthenticateResult result = Authenticator.authenticate(this.authConfiguration, httpRequest, subject -> AuthenticationFilter.executeAs(request, response, chain, subject));
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        switch (result) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: {
                ServletHelpers.doForbidden(httpResponse);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.authConfiguration.isNoCredentials401()) {
                    ServletHelpers.doAuthPrompt(this.authConfiguration.getRealm(), httpResponse);
                    break;
                }
                ServletHelpers.doForbidden(httpResponse);
            }
        }
    }

    private boolean validateSession(HttpServletRequest request, HttpSession session, Subject subject) {
        String authHeader = request.getHeader("Authorization");
        AuthInfo info = new AuthInfo();
        if (authHeader != null && !authHeader.equals("")) {
            Authenticator.extractAuthInfo(authHeader, (userName, password) -> {
                info.username = userName;
            });
        }
        String sessionUser = (String)session.getAttribute("user");
        if (info.username == null || info.username.equals(sessionUser)) {
            LOG.debug("Session subject - {}", (Object)subject);
            return true;
        }
        LOG.debug("User differs, re-authenticating: {} (request) != {} (session)", (Object)info.username, (Object)sessionUser);
        session.invalidate();
        return false;
    }

    private static void executeAs(ServletRequest request, ServletResponse response, FilterChain chain, Subject subject) {
        try {
            Subject.doAs(subject, () -> {
                chain.doFilter(request, response);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            LOG.info("Failed to invoke action " + ((HttpServletRequest)request).getPathInfo() + " due to:", (Throwable)e);
        }
    }

    public void destroy() {
        LOG.info("Destroying hawtio authentication filter");
    }
}

