/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTagHrefFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(BaseTagHrefFilter.class);
    public static final String PARAM_APPLICATION_CONTEXT_PATH = "applicationContextPath";
    private static final String DEFAULT_CONTEXT_PATH = "/hawtio";
    private String applicationContextPath;
    private String basePath;

    public void init(FilterConfig filterConfig) throws ServletException {
        String path = filterConfig.getInitParameter(PARAM_APPLICATION_CONTEXT_PATH);
        this.applicationContextPath = path != null ? path : "";
        ServletContext context = filterConfig.getServletContext();
        String contextPath = context.getContextPath();
        this.basePath = contextPath == null || contextPath.isEmpty() ? (!this.applicationContextPath.startsWith("/") ? "/" : "") : contextPath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        String baseTagHref = this.basePath + this.applicationContextPath;
        if (baseTagHref.equals(DEFAULT_CONTEXT_PATH)) {
            filterChain.doFilter(request, response);
        } else {
            BaseTagHrefResponseWrapper requestWrapper = new BaseTagHrefResponseWrapper((HttpServletResponse)response);
            filterChain.doFilter(request, (ServletResponse)requestWrapper);
            ServletOutputStream out = response.getOutputStream();
            String contentType = response.getContentType();
            byte[] data = requestWrapper.getData();
            if (contentType != null && contentType.startsWith("text/html")) {
                if (!baseTagHref.endsWith("/")) {
                    baseTagHref = baseTagHref + "/";
                }
                String characterEncoding = requestWrapper.getCharacterEncoding() != null ? requestWrapper.getCharacterEncoding() : StandardCharsets.UTF_8.name();
                String originalContent = new String(data, characterEncoding);
                byte[] replacedContent = originalContent.replaceAll("<base href='.*?'>", "<base href='" + baseTagHref + "'>").getBytes(characterEncoding);
                requestWrapper.setContentLength(replacedContent.length);
                out.write(replacedContent);
            } else {
                out.write(data);
            }
        }
    }

    public void destroy() {
    }

    private class BaseTagHrefResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream output;

        public BaseTagHrefResponseWrapper(HttpServletResponse response) {
            super(response);
            this.output = new ByteArrayOutputStream();
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new FilterServletOutputStream(this.output);
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }
    }

    private class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

