/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.system.ConfigManager;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpHeaderFilter
implements Filter {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpHeaderFilter.class);
    private ConfigManager configManager;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.configManager = (ConfigManager)filterConfig.getServletContext().getAttribute("ConfigManager");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.addHeaders((HttpServletRequest)request, (HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    protected abstract void addHeaders(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected String getConfigParameter(String key) {
        return this.configManager.get(key, null);
    }
}

