/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.proxy;

import io.hawt.system.ConfigManager;
import io.hawt.system.ProxyAllowlist;
import io.hawt.util.Strings;
import io.hawt.web.ForbiddenReason;
import io.hawt.web.ServletHelpers;
import io.hawt.web.proxy.ProxyAddress;
import io.hawt.web.proxy.ProxyDetails;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Formatter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.HeaderGroup;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 7792226114533360114L;
    private static final Logger LOG;
    public static final String P_FORWARDEDFOR = "forwardip";
    private static final String PROXY_ACCEPT_SELF_SIGNED_CERTS = "hawtio.proxyDisableCertificateValidation";
    private static final String PROXY_ACCEPT_SELF_SIGNED_CERTS_ENV = "PROXY_DISABLE_CERT_VALIDATION";
    public static final String PROXY_ALLOWLIST = "proxyAllowlist";
    public static final String LOCAL_ADDRESS_PROBING = "localAddressProbing";
    public static final String DISABLE_PROXY = "disableProxy";
    public static final String HAWTIO_PROXY_ALLOWLIST = "hawtio.proxyAllowlist";
    public static final String HAWTIO_LOCAL_ADDRESS_PROBING = "hawtio.localAddressProbing";
    public static final String HAWTIO_DISABLE_PROXY = "hawtio.disableProxy";
    protected boolean enabled = true;
    protected boolean doForwardIP = true;
    protected boolean acceptSelfSignedCerts = false;
    protected ProxyAllowlist allowlist;
    protected CloseableHttpClient proxyClient;
    private CookieStore cookieStore;
    protected static final HeaderGroup hopByHopHeaders;
    protected static final BitSet asciiQueryChars;

    public String getServletInfo() {
        return "A proxy servlet by David Smiley, dsmiley@mitre.org";
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ConfigManager config = (ConfigManager)this.getServletContext().getAttribute("ConfigManager");
        boolean bl = this.enabled = !config.getBoolean(DISABLE_PROXY, false);
        if (!this.enabled) {
            LOG.info("Proxy servlet is disabled");
            return;
        }
        String allowlistStr = config.get(PROXY_ALLOWLIST, servletConfig.getInitParameter(PROXY_ALLOWLIST));
        boolean probeLocal = config.getBoolean(LOCAL_ADDRESS_PROBING, true);
        this.allowlist = new ProxyAllowlist(allowlistStr, probeLocal);
        String doForwardIPString = servletConfig.getInitParameter(P_FORWARDEDFOR);
        if (doForwardIPString != null) {
            this.doForwardIP = Boolean.parseBoolean(doForwardIPString);
        }
        this.cookieStore = new BasicCookieStore();
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCookieStore(this.cookieStore).useSystemProperties();
        if (System.getProperty(PROXY_ACCEPT_SELF_SIGNED_CERTS) != null) {
            this.acceptSelfSignedCerts = Boolean.parseBoolean(System.getProperty(PROXY_ACCEPT_SELF_SIGNED_CERTS));
        } else if (System.getenv(PROXY_ACCEPT_SELF_SIGNED_CERTS_ENV) != null) {
            this.acceptSelfSignedCerts = Boolean.parseBoolean(System.getenv(PROXY_ACCEPT_SELF_SIGNED_CERTS_ENV));
        }
        if (this.acceptSelfSignedCerts) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (x509Certificates, s) -> true);
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(builder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                throw new ServletException((Throwable)e);
            }
        }
        this.proxyClient = httpClientBuilder.build();
    }

    public void destroy() {
        try {
            if (this.proxyClient != null) {
                this.proxyClient.close();
            }
        }
        catch (IOException e) {
            this.log("While destroying servlet, shutting down httpclient: " + e, e);
            LOG.error("While destroying servlet, shutting down httpclient: " + e, (Throwable)e);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        Header proxyAuthHeader;
        BasicHttpRequest proxyRequest;
        URI targetUriObj;
        ProxyDetails details;
        if ("/enabled".equals(servletRequest.getPathInfo())) {
            ServletHelpers.sendJSONResponse(servletResponse, this.enabled);
            return;
        }
        if (!this.enabled) {
            servletResponse.setStatus(404);
            return;
        }
        ProxyAddress proxyAddress = this.parseProxyAddress(servletRequest);
        if (proxyAddress == null || proxyAddress.getFullProxyUrl() == null) {
            servletResponse.setStatus(404);
            return;
        }
        if (proxyAddress instanceof ProxyDetails && !this.allowlist.isAllowed(details = (ProxyDetails)proxyAddress)) {
            LOG.debug("Rejecting {}", (Object)proxyAddress);
            ServletHelpers.doForbidden(servletResponse, ForbiddenReason.HOST_NOT_ALLOWED);
            return;
        }
        String method = servletRequest.getMethod();
        String proxyRequestUri = proxyAddress.getFullProxyUrl();
        try {
            targetUriObj = new URI(proxyRequestUri);
        }
        catch (URISyntaxException e) {
            LOG.error("URL '{}' is not valid: {}", (Object)proxyRequestUri, (Object)e.getMessage());
            servletResponse.setStatus(404);
            return;
        }
        if (servletRequest.getHeader("Content-Length") != null || servletRequest.getHeader("Transfer-Encoding") != null) {
            BasicHttpEntityEnclosingRequest eProxyRequest = new BasicHttpEntityEnclosingRequest(method, proxyRequestUri);
            eProxyRequest.setEntity((HttpEntity)new InputStreamEntity((InputStream)servletRequest.getInputStream(), (long)servletRequest.getContentLength()));
            proxyRequest = eProxyRequest;
        } else {
            proxyRequest = new BasicHttpRequest(method, proxyRequestUri);
        }
        this.copyRequestHeaders(servletRequest, (HttpRequest)proxyRequest, targetUriObj);
        String username = proxyAddress.getUserName();
        String password = proxyAddress.getPassword();
        if (Strings.isNotBlank(username) && Strings.isNotBlank(password)) {
            String encodedCreds = Base64.encodeBase64String((byte[])(username + ":" + password).getBytes());
            proxyRequest.setHeader("Authorization", "Basic " + encodedCreds);
        }
        if ((proxyAuthHeader = proxyRequest.getFirstHeader("Authorization")) != null) {
            String proxyAuth = proxyAuthHeader.getValue();
            HttpSession session = servletRequest.getSession();
            if (session != null) {
                String previousProxyCredentials = (String)session.getAttribute("proxy-credentials");
                if (previousProxyCredentials != null && !previousProxyCredentials.equals(proxyAuth)) {
                    this.cookieStore.clear();
                }
                session.setAttribute("proxy-credentials", (Object)proxyAuth);
            }
        }
        this.setXForwardedForHeader(servletRequest, (HttpRequest)proxyRequest);
        CloseableHttpResponse proxyResponse = null;
        int statusCode = 0;
        try {
            LOG.debug("proxy {} uri: {} -- {}", new Object[]{method, servletRequest.getRequestURI(), proxyRequest.getRequestLine().getUri()});
            proxyResponse = this.proxyClient.execute(URIUtils.extractHost((URI)targetUriObj), (HttpRequest)proxyRequest);
            statusCode = proxyResponse.getStatusLine().getStatusCode();
            if (statusCode == 401 || statusCode == 403) {
                LOG.debug("Authentication Failed on remote server {}", (Object)proxyRequestUri);
            } else if (this.doResponseRedirectOrNotModifiedLogic(servletRequest, servletResponse, (HttpResponse)proxyResponse, statusCode, targetUriObj)) {
                return;
            }
            servletResponse.setStatus(statusCode, proxyResponse.getStatusLine().getReasonPhrase());
            this.copyResponseHeaders((HttpResponse)proxyResponse, servletResponse);
            this.copyResponseEntity((HttpResponse)proxyResponse, servletResponse);
        }
        catch (Exception e) {
            if (proxyRequest instanceof AbortableHttpRequest) {
                AbortableHttpRequest abortableHttpRequest = (AbortableHttpRequest)proxyRequest;
                abortableHttpRequest.abort();
            }
            LOG.debug("Proxy to " + proxyRequestUri + " failed", (Throwable)e);
            if (e instanceof ConnectException || e instanceof UnknownHostException) {
                servletResponse.setStatus(404);
            } else if (e instanceof ServletException) {
                servletResponse.sendError(502, e.getMessage());
            } else if (e instanceof SecurityException) {
                servletResponse.setHeader("WWW-Authenticate", "Basic");
                servletResponse.sendError(statusCode, e.getMessage());
            } else {
                servletResponse.sendError(500, e.getMessage());
            }
        }
        finally {
            if (proxyResponse != null) {
                EntityUtils.consumeQuietly((HttpEntity)proxyResponse.getEntity());
                try {
                    proxyResponse.close();
                }
                catch (IOException e) {
                    LOG.error("Error closing proxy client response: {}", (Object)e.getMessage());
                }
            }
        }
    }

    protected ProxyAddress parseProxyAddress(HttpServletRequest servletRequest) {
        return new ProxyDetails(servletRequest);
    }

    protected boolean doResponseRedirectOrNotModifiedLogic(HttpServletRequest servletRequest, HttpServletResponse servletResponse, HttpResponse proxyResponse, int statusCode, URI targetUriObj) throws ServletException, IOException {
        if (statusCode >= 300 && statusCode < 304) {
            Header locationHeader = proxyResponse.getLastHeader("Location");
            if (locationHeader == null) {
                throw new ServletException("Received status code: " + statusCode + " but no Location header was found in the response");
            }
            String locStr = this.rewriteUrlFromResponse(servletRequest, locationHeader.getValue(), targetUriObj.toString());
            servletResponse.sendRedirect(locStr);
            return true;
        }
        if (statusCode == 304) {
            servletResponse.setIntHeader("Content-Length", 0);
            servletResponse.setStatus(304);
            return true;
        }
        return false;
    }

    protected void copyRequestHeaders(HttpServletRequest servletRequest, HttpRequest proxyRequest, URI targetUriObj) {
        Enumeration enumerationOfHeaderNames = servletRequest.getHeaderNames();
        while (enumerationOfHeaderNames.hasMoreElements()) {
            String headerName = (String)enumerationOfHeaderNames.nextElement();
            if (headerName.equalsIgnoreCase("Content-Length") || hopByHopHeaders.containsHeader(headerName)) continue;
            Enumeration headers = servletRequest.getHeaders(headerName);
            while (headers.hasMoreElements()) {
                HttpHost host;
                Object headerValue = (String)headers.nextElement();
                if (headerName.equalsIgnoreCase("Host") && (host = URIUtils.extractHost((URI)targetUriObj)) != null && (headerValue = host.getHostName()) != null && host.getPort() != -1) {
                    headerValue = (String)headerValue + ":" + host.getPort();
                }
                proxyRequest.addHeader(headerName, (String)headerValue);
            }
        }
    }

    private void setXForwardedForHeader(HttpServletRequest servletRequest, HttpRequest proxyRequest) {
        String headerName = "X-Forwarded-For";
        if (this.doForwardIP) {
            Object newHeader = servletRequest.getRemoteAddr();
            String existingHeader = servletRequest.getHeader(headerName);
            if (existingHeader != null) {
                newHeader = existingHeader + ", " + (String)newHeader;
            }
            proxyRequest.setHeader(headerName, (String)newHeader);
        }
    }

    protected void copyResponseHeaders(HttpResponse proxyResponse, HttpServletResponse servletResponse) {
        for (Header header : proxyResponse.getAllHeaders()) {
            if (hopByHopHeaders.containsHeader(header.getName())) continue;
            servletResponse.addHeader(header.getName(), header.getValue());
        }
    }

    protected void copyResponseEntity(HttpResponse proxyResponse, HttpServletResponse servletResponse) throws IOException {
        HttpEntity entity = proxyResponse.getEntity();
        if (entity != null) {
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            entity.writeTo((OutputStream)servletOutputStream);
        }
    }

    protected String rewriteUrlFromResponse(HttpServletRequest servletRequest, String theUrl, String targetUri) {
        if (((String)theUrl).startsWith(targetUri)) {
            String curUrl = servletRequest.getRequestURL().toString();
            String pathInfo = servletRequest.getPathInfo();
            if (pathInfo != null) {
                assert (curUrl.endsWith(pathInfo));
                curUrl = curUrl.substring(0, curUrl.length() - pathInfo.length());
            }
            theUrl = curUrl + ((String)theUrl).substring(targetUri.length());
        }
        return theUrl;
    }

    protected static CharSequence encodeUriQuery(CharSequence in) {
        CharSequence outBuf = null;
        Formatter formatter = null;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            boolean escape = true;
            if (c < '\u0080') {
                if (asciiQueryChars.get(c)) {
                    escape = false;
                }
            } else if (!Character.isISOControl(c) && !Character.isSpaceChar(c)) {
                escape = false;
            }
            if (!escape) {
                if (outBuf == null) continue;
                ((StringBuilder)outBuf).append(c);
                continue;
            }
            if (outBuf == null) {
                outBuf = new StringBuilder(in.length() + 15);
                ((StringBuilder)outBuf).append(in, 0, i);
                formatter = new Formatter((Appendable)((Object)outBuf));
            }
            formatter.format("%%%02X", c);
        }
        return outBuf != null ? outBuf : in;
    }

    static {
        int c;
        String[] headers;
        LOG = LoggerFactory.getLogger(ProxyServlet.class);
        hopByHopHeaders = new HeaderGroup();
        for (String header : headers = new String[]{"Connection", "Keep-Alive", "Proxy-Authenticate", "Proxy-Authorization", "TE", "Trailers", "Transfer-Encoding", "Upgrade", "Cookie", "Set-Cookie"}) {
            hopByHopHeaders.addHeader((Header)new BasicHeader(header, null));
        }
        char[] c_unreserved = "_-!.~'()*".toCharArray();
        char[] c_punct = ",;:$&+=".toCharArray();
        char[] c_reserved = "?/[]@".toCharArray();
        asciiQueryChars = new BitSet(128);
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            asciiQueryChars.set(c);
        }
        for (char c2 : c_unreserved) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_punct) {
            asciiQueryChars.set(c2);
        }
        for (char c2 : c_reserved) {
            asciiQueryChars.set(c2);
        }
        asciiQueryChars.set(37);
    }
}

