/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.tomcat;

import io.hawt.util.Predicate;
import io.hawt.web.tomcat.TomcatPrincipal;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TomcatUserDatabaseLoginContext
implements LoginModule {
    private static final Logger LOG = LoggerFactory.getLogger(TomcatUserDatabaseLoginContext.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private final String fileName = "conf/tomcat-users.xml";
    private File file;
    private String digestAlgorithm;
    private static final Map<String, Predicate<PasswordPair>> PASSWORD_CHECKS;
    public static final String OPTION_DIGEST_ALGORITHM = "DIGEST_ALGORITHM";
    public static final String OPTION_TOMCAT_USER_LOCATION = "USER_LOCATION";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String msg;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        Object customLocation = options.get(OPTION_TOMCAT_USER_LOCATION);
        if (customLocation != null) {
            this.file = new File(customLocation.toString(), "tomcat-users.xml");
        }
        if (this.file == null || !this.file.exists()) {
            String base = System.getProperty("catalina.base", ".");
            LOG.debug("Using base directory: {}", (Object)base);
            this.file = new File(base, "conf/tomcat-users.xml");
        }
        if (!this.file.exists()) {
            msg = "Cannot find Apache Tomcat user database file: " + this.file;
            LOG.warn(msg);
            throw new IllegalStateException(msg);
        }
        this.digestAlgorithm = options.get(OPTION_DIGEST_ALGORITHM).toString();
        if (!PASSWORD_CHECKS.containsKey(this.digestAlgorithm)) {
            msg = "Invalid digest algorithm specified: " + this.digestAlgorithm + " (valid: " + PASSWORD_CHECKS.keySet() + ")";
            LOG.warn(msg);
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public boolean login() throws LoginException {
        block6: {
            Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
            try {
                this.callbackHandler.handle(callbacks);
                String username = ((NameCallback)callbacks[0]).getName();
                char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
                String password = new String(tmpPassword);
                ((PasswordCallback)callbacks[1]).clearPassword();
                LOG.debug("Getting user details for username {}", (Object)username);
                String[] user = this.getUserPasswordRole(username);
                if (user != null) {
                    String[] roles;
                    if (!this.passwordsMatch(new PasswordPair(user[1], password))) {
                        LOG.trace("Login denied due password did not match");
                        return false;
                    }
                    for (String role : roles = user[2].split(",")) {
                        LOG.trace("User {} has role {}", (Object)username, (Object)role);
                        this.subject.getPrincipals().add(new TomcatPrincipal(role));
                    }
                    break block6;
                }
                LOG.trace("Login denied due user not found");
                return false;
            }
            catch (UnsupportedCallbackException uce) {
                LoginException le = new LoginException("Error: " + uce.getCallback().toString() + " not available to gather authentication information from the user");
                le.initCause(uce);
                throw le;
            }
            catch (Exception ioe) {
                LoginException le = new LoginException(ioe.toString());
                le.initCause(ioe);
                throw le;
            }
        }
        return true;
    }

    protected boolean passwordsMatch(PasswordPair passwordPair) {
        return PASSWORD_CHECKS.get(this.digestAlgorithm).evaluate(passwordPair);
    }

    @Override
    public boolean commit() {
        return true;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject = null;
        this.callbackHandler = null;
        return true;
    }

    protected String[] getUserPasswordRole(String username) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document dom = builder.parse(this.file);
        NodeList users = dom.getElementsByTagName("user");
        for (int i = 0; i < users.getLength(); ++i) {
            Node node = users.item(i);
            String nUsername = node.getAttributes().getNamedItem("username").getNodeValue();
            String nPassword = node.getAttributes().getNamedItem("password").getNodeValue();
            String nRoles = node.getAttributes().getNamedItem("roles").getNodeValue();
            if (!username.equals(nUsername)) continue;
            return new String[]{username, nPassword, nRoles};
        }
        return null;
    }

    static {
        HashMap<String, Predicate<PasswordPair>> temp = new HashMap<String, Predicate<PasswordPair>>(6);
        temp.put("NONE", passwordPair -> passwordPair.getFilePassword().equals(passwordPair.getSuppliedPassword()));
        temp.put("MD5", new Predicate<PasswordPair>(){

            @Override
            public boolean evaluate(PasswordPair passwordPair) {
                return passwordPair.getFilePassword().equals(DigestUtils.md5Hex((String)passwordPair.getSuppliedPassword()));
            }
        });
        temp.put("SHA-256", passwordPair -> passwordPair.getFilePassword().equals(DigestUtils.sha256Hex((String)passwordPair.getSuppliedPassword())));
        temp.put("SHA", passwordPair -> passwordPair.getFilePassword().equals(DigestUtils.shaHex((String)passwordPair.getSuppliedPassword())));
        temp.put("SHA-512", passwordPair -> passwordPair.getFilePassword().equals(DigestUtils.sha512Hex((String)passwordPair.getSuppliedPassword())));
        temp.put("SHA-384", passwordPair -> passwordPair.getFilePassword().equals(DigestUtils.sha384Hex((String)passwordPair.getSuppliedPassword())));
        PASSWORD_CHECKS = Collections.unmodifiableMap(temp);
    }

    private static class PasswordPair {
        private final String filePassword;
        private final String suppliedPassword;

        private PasswordPair(String filePassword, String suppliedPassword) {
            this.filePassword = filePassword;
            this.suppliedPassword = suppliedPassword;
        }

        public String getFilePassword() {
            return this.filePassword;
        }

        public String getSuppliedPassword() {
            return this.suppliedPassword;
        }
    }
}

