/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.system;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    public static final String FORCE_PROPERTIES = "forceProperties";
    public static final String CONFIG_MANAGER = "ConfigManager";
    private Context envContext = null;
    private final Function<String, String> propertyResolver;

    public ConfigManager() {
        this.propertyResolver = ConfigManager::getHawtioSystemProperty;
    }

    public ConfigManager(Function<String, String> propertyResolver) {
        Objects.requireNonNull(propertyResolver);
        this.propertyResolver = x -> ConfigManager.getProperty(x, ConfigManager::getHawtioSystemProperty, propertyResolver);
    }

    public void init() {
        if (Boolean.parseBoolean(ConfigManager.getHawtioSystemProperty(FORCE_PROPERTIES))) {
            LOG.info("Forced using system properties");
            return;
        }
        try {
            this.envContext = (Context)new InitialContext().lookup("java:comp/env");
            LOG.info("Configuration will be discovered via JNDI");
        }
        catch (NamingException e) {
            LOG.debug("Failed to look up environment context: {}", (Object)e.getMessage());
            LOG.info("Configuration will be discovered via system properties");
        }
    }

    public void destroy() {
        if (this.envContext != null) {
            try {
                this.envContext.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.envContext = null;
        }
    }

    public Optional<String> get(String name) {
        String answer = null;
        if (this.envContext != null) {
            try {
                answer = (String)this.envContext.lookup("hawtio/" + name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (answer == null) {
            answer = this.propertyResolver.apply(name);
        }
        LOG.debug("Property {} is set to value {}", (Object)name, answer);
        return Optional.ofNullable(answer);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.get(name).orElse(Boolean.toString(defaultValue)));
    }

    private static String getHawtioSystemProperty(String name) {
        return System.getProperty("hawtio." + name);
    }

    @SafeVarargs
    private static String getProperty(String name, Function<String, String> ... propertyResolvers) {
        return Arrays.stream(propertyResolvers).map(resolver -> (String)resolver.apply(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

