/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.filters.HttpHeaderFilter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferrerPolicyFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ReferrerPolicyFilter.class);
    public static final String REFERRER_POLICY = "http.referrerPolicy";
    public static final String HAWTIO_REFERRER_POLICY = "hawtio.http.referrerPolicy";
    private String headerValue = "strict-origin";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String policy = this.getConfigParameter(REFERRER_POLICY);
        if (policy != null) {
            this.headerValue = policy;
        }
        LOG.debug("Referrer-Policy is configured: {}", (Object)this.headerValue);
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.addHeader("Referrer-Policy", this.headerValue);
    }
}

