/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    protected int timeout;
    protected AuthenticationConfiguration authConfiguration;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext());
        this.timeout = AuthSessionHelpers.getSessionTimeout(filterConfig.getServletContext());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path: {}", (Object)path);
        if (this.authConfiguration.getRealm() == null || this.authConfiguration.getRealm().isEmpty() || !this.authConfiguration.isEnabled()) {
            LOG.debug("No authentication needed for path: {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (session != null) {
            Subject subject2 = (Subject)session.getAttribute("subject");
            if (AuthSessionHelpers.isSpringSecurityEnabled()) {
                if (subject2 == null && httpRequest.getRemoteUser() != null) {
                    AuthSessionHelpers.setup(session, new Subject(), httpRequest.getRemoteUser(), this.timeout);
                }
                chain.doFilter(request, response);
                return;
            }
            if (AuthSessionHelpers.validate(httpRequest, session, subject2)) {
                AuthenticationFilter.executeAs(request, response, chain, subject2);
                return;
            }
        }
        LOG.debug("Doing authentication and authorization for path: {}", (Object)path);
        AuthenticateResult result = new Authenticator(httpRequest, this.authConfiguration).authenticate(subject -> AuthenticationFilter.executeAs(request, response, chain, subject));
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        switch (result) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: {
                ServletHelpers.doForbidden(httpResponse);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.authConfiguration.isNoCredentials401()) {
                    ServletHelpers.doAuthPrompt(this.authConfiguration.getRealm(), httpResponse);
                    break;
                }
                ServletHelpers.doForbidden(httpResponse);
            }
        }
    }

    private static void executeAs(ServletRequest request, ServletResponse response, FilterChain chain, Subject subject) {
        try {
            Subject.doAs(subject, () -> {
                chain.doFilter(request, response);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            LOG.info("Failed to invoke action " + ((HttpServletRequest)request).getPathInfo() + " due to:", (Throwable)e);
        }
    }

    public void destroy() {
        LOG.info("Destroying hawtio authentication filter");
    }
}

