/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.util.Strings;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.RelativeRequestUri;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionExpiryFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(SessionExpiryFilter.class);
    public static final String SERVLET_PATH = "hawtioServletPath";
    public static final String ATTRIBUTE_LAST_ACCESS = "LastAccess";
    private static final List<String> IGNORED_PATHS = List.of("jolokia", "proxy");
    private ServletContext context;
    private int pathIndex;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.context = filterConfig.getServletContext();
        String servletPath = (String)filterConfig.getServletContext().getAttribute(SERVLET_PATH);
        this.pathIndex = servletPath == null ? 0 : Strings.webContextPath(servletPath, new String[0]).replaceAll("[^/]+", "").length();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        if (servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse) {
            this.process((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, filterChain);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void writeOk(HttpServletResponse response) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        try (ServletOutputStream out = response.getOutputStream();){
            out.write("ok".getBytes());
            out.flush();
        }
    }

    private void updateLastAccess(HttpSession session, long now) {
        session.setAttribute(ATTRIBUTE_LAST_ACCESS, (Object)now);
        LOG.debug("Reset LastAccess to: {}", (Object)now);
    }

    private void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.context.getAttribute("authenticationEnabled") == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        HttpSession session = request.getSession(false);
        boolean enabled = (Boolean)this.context.getAttribute("authenticationEnabled");
        RelativeRequestUri uri = new RelativeRequestUri(request, this.pathIndex);
        LOG.debug("Accessing [{}], hawtio path is [{}]", (Object)request.getRequestURI(), (Object)uri.getUri());
        if (uri.getComponents().length == 0) {
            if (session != null) {
                long now = System.currentTimeMillis();
                this.updateLastAccess(session, now);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String subContext = uri.getComponents()[0];
        if (session == null || session.getMaxInactiveInterval() < 0) {
            if (subContext.equals("refresh") && !enabled) {
                LOG.debug("Authentication disabled, received refresh response, responding with ok");
                this.writeOk(response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            return;
        }
        int maxInactiveInterval = session.getMaxInactiveInterval();
        long now = System.currentTimeMillis();
        if (session.getAttribute(ATTRIBUTE_LAST_ACCESS) != null) {
            long lastAccess = (Long)session.getAttribute(ATTRIBUTE_LAST_ACCESS);
            long remainder = (now - lastAccess) / 1000L;
            LOG.debug("Session expiry: {}s, duration since last access: {}s", (Object)maxInactiveInterval, (Object)remainder);
            if (remainder > (long)maxInactiveInterval) {
                LOG.info("Expiring session due to inactivity");
                session.invalidate();
                ServletHelpers.doForbidden(response);
                return;
            }
        }
        if (subContext.equals("refresh")) {
            this.updateLastAccess(session, now);
            this.writeOk(response);
            return;
        }
        LOG.debug("SubContext: {}", (Object)subContext);
        if (IGNORED_PATHS.contains(subContext) && session.getAttribute(ATTRIBUTE_LAST_ACCESS) != null) {
            LOG.debug("Not updating LastAccess");
        } else {
            this.updateLastAccess(session, now);
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void destroy() {
    }
}

