/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth.keycloak;

import io.hawt.system.AuthHelpers;
import io.hawt.system.Authenticator;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.UserServlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.atomic.AtomicReference;

public class KeycloakUserServlet
extends UserServlet {
    private static final long serialVersionUID = 1734127369954899957L;
    private AuthenticationConfiguration authConfiguration;
    private boolean keycloakEnabled;

    @Override
    public void init() throws ServletException {
        super.init();
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(this.getServletContext());
        this.keycloakEnabled = this.authConfiguration.isKeycloakEnabled();
    }

    @Override
    protected String getUsername(HttpServletRequest req, HttpServletResponse resp) {
        if (this.keycloakEnabled) {
            return this.getKeycloakUsername(req);
        }
        return super.getUsername(req, resp);
    }

    protected String getKeycloakUsername(HttpServletRequest req) {
        AtomicReference username = new AtomicReference();
        new Authenticator(req, this.authConfiguration).authenticate(subject -> {
            username.set(AuthHelpers.getUsername(subject));
            req.getSession(true);
        });
        return (String)username.get();
    }
}

