/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CORSFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(CORSFilter.class);
    public static final String ENABLE_CORS = "http.enableCORS";
    public static final String HAWTIO_ENABLE_CORS = "hawtio.http.enableCORS";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN = "http.accessControlAllowOrigin";
    public static final String HAWTIO_ACCESS_CONTROL_ALLOW_ORIGIN = "hawtio.http.accessControlAllowOrigin";
    private boolean enabled = false;
    private String headerValue = "*";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String origin;
        super.init(filterConfig);
        String enableCORS = this.getConfigParameter(ENABLE_CORS);
        if (Boolean.parseBoolean(enableCORS)) {
            this.enabled = true;
            LOG.debug("CORS enabled");
        }
        if ((origin = this.getConfigParameter(ACCESS_CONTROL_ALLOW_ORIGIN)) != null) {
            this.headerValue = origin;
        }
        LOG.debug("Access-Control-Allow-Origin is configured: {}", (Object)this.headerValue);
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!this.enabled) {
            return;
        }
        if ("OPTIONS".equals(request.getMethod())) {
            response.addHeader("Access-Control-Request-Method", "GET, POST, PUT, DELETE");
            String headers = request.getHeader("Access-Control-Request-Headers");
            if (headers != null) {
                response.addHeader("Access-Control-Allow-Headers", headers);
            }
            response.addHeader("Access-Control-Max-Age", "" + TimeUnit.DAYS.toSeconds(1L));
        }
        response.addHeader("Access-Control-Allow-Origin", this.headerValue);
    }
}

