/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.proxy;

import io.hawt.system.Authenticator;
import io.hawt.util.Strings;
import io.hawt.web.proxy.ProxyAddress;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyDetails
implements ProxyAddress {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyDetails.class);
    private String stringProxyURL;
    private String hostAndPort;
    private String scheme = "http";
    private String path = "";
    private String userName;
    private String password;
    private String host;
    private int port = 80;
    public static final String USER_PARAM = "_user";
    public static final String PWD_PARAM = "_pwd";
    private static final Set<String> ignoreHeaderNames = new HashSet<String>(Arrays.asList("_user", "_pwd", "_url", "url"));

    public ProxyDetails(HttpServletRequest httpServletRequest) {
        this(httpServletRequest.getPathInfo());
        Authenticator.extractAuthHeader(httpServletRequest, (user, pass) -> {
            this.userName = user;
            this.password = pass;
        });
        Enumeration iter = httpServletRequest.getParameterNames();
        while (iter != null && iter.hasMoreElements()) {
            String[] values;
            String name;
            Object next = iter.nextElement();
            if (!(next instanceof String) || ignoreHeaderNames.contains(name = next.toString())) continue;
            for (String value : values = httpServletRequest.getParameterValues(name)) {
                String prefix = "?";
                if (this.stringProxyURL.contains("?")) {
                    prefix = "&";
                }
                this.stringProxyURL = this.stringProxyURL + prefix + name + "=" + value;
            }
        }
    }

    public ProxyDetails(String pathInfo) {
        this.hostAndPort = pathInfo.replace(" ", "%20");
        while (this.hostAndPort.startsWith("/")) {
            this.hostAndPort = this.hostAndPort.substring(1);
        }
        if (this.hostAndPort.startsWith("http/")) {
            this.scheme = "http";
            this.hostAndPort = this.hostAndPort.substring(5);
        } else if (this.hostAndPort.startsWith("https/")) {
            this.scheme = "https";
            this.hostAndPort = this.hostAndPort.substring(6);
        }
        int idx = this.hostAndPort.indexOf("@");
        if (idx > 0) {
            this.userName = this.hostAndPort.substring(0, idx);
            this.hostAndPort = this.hostAndPort.substring(idx + 1);
            idx = this.indexOf(this.userName, ":", "/");
            if (idx > 0) {
                this.password = this.userName.substring(idx + 1);
                this.userName = this.userName.substring(0, idx);
            }
        }
        this.host = this.hostAndPort;
        int schemeIdx = this.indexOf(this.hostAndPort, "://");
        if (schemeIdx > 0) {
            this.scheme = this.hostAndPort.substring(0, schemeIdx);
            this.hostAndPort = this.hostAndPort.substring(schemeIdx + 3);
        } else {
            schemeIdx = this.indexOf(this.hostAndPort, ":/");
            if (schemeIdx > 0) {
                this.scheme = this.hostAndPort.substring(0, schemeIdx);
                this.hostAndPort = this.hostAndPort.substring(schemeIdx + 2);
            }
        }
        idx = this.indexOf(this.hostAndPort, ":", "/");
        if (idx > 0) {
            this.host = this.hostAndPort.substring(0, idx);
            String portText = this.hostAndPort.substring(idx + 1);
            if ((idx = portText.indexOf("/")) >= 0) {
                this.path = portText.substring(idx);
                portText = portText.substring(0, idx);
            }
            if (Strings.isNotBlank(portText)) {
                try {
                    this.port = Integer.parseInt(portText);
                    this.hostAndPort = this.host + ":" + this.port;
                }
                catch (NumberFormatException e) {
                    this.port = "http".equals(this.scheme) ? 80 : 443;
                    this.path = "/" + portText + this.path;
                    this.hostAndPort = this.host;
                }
            } else {
                this.hostAndPort = this.host;
            }
        }
        this.stringProxyURL = this.scheme + "://" + this.hostAndPort + this.path;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Proxying to " + this.stringProxyURL + " as user: " + this.userName);
        }
    }

    public boolean isAllowed(Set<String> allowlist) {
        if (allowlist.contains("*")) {
            return true;
        }
        return allowlist.contains(this.host.split(":")[0]);
    }

    public boolean isAllowed(List<Pattern> regexAllowlist) {
        String hostWithoutPort = this.host.split(":")[0];
        for (Pattern pattern : regexAllowlist) {
            if (!pattern.matcher(hostWithoutPort).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getFullProxyUrl() {
        return this.stringProxyURL;
    }

    public String toString() {
        return String.format("ProxyDetails{%s@%s/%s}", this.userName, this.hostAndPort, this.stringProxyURL);
    }

    protected int indexOf(String text, String ... values) {
        int answer = -1;
        for (String value : values) {
            int idx = text.indexOf(value);
            if (idx < 0 || answer >= 0 && idx >= answer) continue;
            answer = idx;
        }
        return answer;
    }

    public String getStringProxyURL() {
        return this.stringProxyURL;
    }

    public String getProxyHostAndPort() {
        return this.hostAndPort;
    }

    public String getProxyPath() {
        return this.path;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getHostAndPort() {
        return this.hostAndPort;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isValid() {
        return this.hostAndPort != null;
    }
}

