/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthHelpers;
import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.Redirector;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoginRedirectFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(LoginRedirectFilter.class);
    public final String ATTRIBUTE_UNSECURED_PATHS = "unsecuredPaths";
    private int timeout;
    private AuthenticationConfiguration authConfiguration;
    private String[] unsecuredPaths;
    private Redirector redirector = new Redirector();

    public LoginRedirectFilter() {
        this(AuthenticationConfiguration.UNSECURED_PATHS);
    }

    public LoginRedirectFilter(String[] unsecuredPaths) {
        this.unsecuredPaths = unsecuredPaths;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext());
        this.timeout = AuthSessionHelpers.getSessionTimeout(filterConfig.getServletContext());
        LOG.info("Hawtio loginRedirectFilter is using {} sec. HttpSession timeout", (Object)this.timeout);
        Object unsecured = filterConfig.getServletContext().getAttribute("unsecuredPaths");
        if (unsecured != null) {
            this.unsecuredPaths = (String[])unsecured;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpSession session = httpRequest.getSession(false);
        String path = httpRequest.getServletPath();
        if (this.isRedirectRequired(session, path, httpRequest)) {
            this.redirector.doRedirect(httpRequest, httpResponse, "/login");
        } else {
            chain.doFilter(request, response);
        }
    }

    private boolean isRedirectRequired(HttpSession session, String path, HttpServletRequest request) {
        LOG.debug("Check if path [{}] requires redirect", (Object)path);
        return this.authConfiguration.isEnabled() && !this.authConfiguration.isKeycloakEnabled() && !AuthSessionHelpers.isSpringSecurityEnabled() && !AuthSessionHelpers.isAuthenticated(session) && this.isSecuredPath(path) && !this.tryAuthenticateRequest(request, session);
    }

    boolean tryAuthenticateRequest(HttpServletRequest request, HttpSession session) {
        AuthenticateResult result = new Authenticator(request, this.authConfiguration).authenticate(subject -> {
            String username = AuthHelpers.getUsername(subject);
            LOG.info("Logging in user: {}", (Object)username);
            AuthSessionHelpers.setup(session != null ? session : request.getSession(true), subject, username, this.timeout);
        });
        return result.is(AuthenticateResult.Type.AUTHORIZED);
    }

    boolean isSecuredPath(String path) {
        return Arrays.stream(this.unsecuredPaths).noneMatch(path::startsWith);
    }

    public void setRedirector(Redirector redirector) {
        this.redirector = redirector;
    }
}

