/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import io.hawt.util.Strings;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.oidc.OidcConfiguration;
import io.hawt.web.filters.HttpHeaderFilter;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSecurityPolicyFilter
extends HttpHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ContentSecurityPolicyFilter.class);
    private String policy = "";

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        OidcConfiguration oidcConfiguration;
        URL url;
        AuthenticationConfiguration authConfig;
        super.init(filterConfig);
        ArrayList<String> defaultSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> connectSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> fontSrc = new ArrayList<String>(List.of("'self'", "data:"));
        ArrayList<String> frameSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> imgSrc = new ArrayList<String>(List.of("'self'", "data:"));
        ArrayList<String> manifestSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> mediaSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> objectSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> scriptSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> styleSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> workerSrc = new ArrayList<String>(List.of("'self'"));
        ArrayList<String> frameAncestors = new ArrayList<String>();
        if (this.isXFrameSameOriginAllowed()) {
            frameAncestors.add("'self'");
        } else {
            frameAncestors.add("'none'");
        }
        styleSrc.add("'unsafe-inline'");
        String keycloakConfigFile = this.getConfigParameter("keycloakClientConfig");
        if (System.getProperty("hawtio.keycloakClientConfig") != null) {
            keycloakConfigFile = System.getProperty("hawtio.keycloakClientConfig");
        }
        boolean addedKeycloakUrl = false;
        if (Strings.isNotBlank(keycloakConfigFile)) {
            LOG.debug("Reading Keycloak config file from {}", (Object)keycloakConfigFile);
            try (InputStream is = ServletHelpers.loadFile(keycloakConfigFile);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(is)));){
                JSONObject json = ServletHelpers.readObject(reader);
                String url2 = (String)json.get("url");
                URI uri = URI.create(url2);
                LOG.info("Found Keycloak URL: {}", (Object)uri);
                String cspSrc = uri.getScheme() + "://" + uri.getHost();
                if (uri.getPort() >= 0) {
                    cspSrc = cspSrc + ":" + uri.getPort();
                }
                connectSrc.add(cspSrc);
                frameSrc.add(cspSrc);
                scriptSrc.add(cspSrc);
            }
            catch (Exception e) {
                LOG.error("Can't read keycloak configuration file", (Throwable)e);
            }
        }
        if ((authConfig = AuthenticationConfiguration.getConfiguration(filterConfig.getServletContext())).isEnabled() && authConfig.getOidcConfiguration() != null && authConfig.getOidcConfiguration().isEnabled() && (url = (oidcConfiguration = authConfig.getOidcConfiguration()).getProviderURL()) != null) {
            String oidcSrc = String.format("%s://%s%s", url.getProtocol(), url.getHost(), url.getPort() > 0 ? ":" + url.getPort() : "");
            connectSrc.add(oidcSrc);
            frameSrc.add(oidcSrc);
            scriptSrc.add(oidcSrc);
        }
        StringBuilder builder = new StringBuilder();
        this.addPolicy(builder, "default-src", defaultSrc);
        this.addPolicy(builder, "script-src", scriptSrc);
        this.addPolicy(builder, "style-src", styleSrc);
        this.addPolicy(builder, "font-src", fontSrc);
        this.addPolicy(builder, "img-src", imgSrc);
        this.addPolicy(builder, "connect-src", connectSrc);
        this.addPolicy(builder, "frame-src", frameSrc);
        this.addPolicy(builder, "manifest-src", manifestSrc);
        this.addPolicy(builder, "media-src", mediaSrc);
        this.addPolicy(builder, "object-src", objectSrc);
        this.addPolicy(builder, "worker-src", workerSrc);
        this.addPolicy(builder, "frame-ancestors", frameAncestors);
        this.policy = builder.toString().trim();
        this.policy = this.policy.substring(0, this.policy.length() - 1);
    }

    private void addPolicy(StringBuilder builder, String name, List<String> sources) {
        builder.append(name);
        sources.forEach(s -> builder.append(" ").append((String)s));
        builder.append("; ");
    }

    @Override
    protected void addHeaders(HttpServletRequest request, HttpServletResponse response) {
        response.addHeader("Content-Security-Policy", this.policy);
    }
}

