/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class Strings {
    public static boolean isBlank(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean isNotBlank(String text) {
        return text != null && !text.trim().isEmpty();
    }

    public static List<String> split(String text, String delimiter) {
        if (text == null || delimiter == null) {
            throw new IllegalArgumentException("Both 'text' and 'delimiter' should not be null.");
        }
        return Arrays.stream(text.split(delimiter)).map(String::trim).filter(Strings::isNotBlank).collect(Collectors.toList());
    }

    public static String cleanPath(String path) {
        String result = path.replaceAll("//+", "/");
        return result.length() == 1 && result.charAt(0) == '/' ? result : result.replaceAll("/+$", "");
    }

    public static String webContextPath(String first, String ... more) {
        if (more.length == 0 && (first == null || first.isEmpty())) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        if (first != null) {
            if (!first.startsWith("/")) {
                b.append('/');
            }
            b.append(first);
        }
        for (String s : more) {
            if (s == null || s.isEmpty()) continue;
            b.append('/');
            b.append(s);
        }
        String cleanedPath = Strings.cleanPath(b.toString());
        return cleanedPath.length() == 1 ? "" : cleanedPath;
    }

    public static String resolvePlaceholders(String value) {
        return Strings.resolvePlaceholders(value, System.getProperties());
    }

    public static String resolvePlaceholders(String value, Properties properties) {
        if (value == null || !value.contains("$")) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        int l = value.length();
        for (int pos1 = 0; pos1 < l; ++pos1) {
            char c2;
            char c1 = value.charAt(pos1);
            char c = c2 = pos1 == l - 1 ? (char)'\u0000' : value.charAt(pos1 + 1);
            if (c1 == '$' && c2 == '{') {
                int depth = 1;
                int pos2 = pos1 + 2;
                while (depth > 0 && pos2 < l) {
                    if (value.charAt(pos2) == '$' && pos2 < l - 1 && value.charAt(pos2 + 1) == '{') {
                        ++depth;
                        pos2 += 2;
                        continue;
                    }
                    if (value.charAt(pos2) == '}') {
                        --depth;
                        ++pos2;
                        continue;
                    }
                    ++pos2;
                }
                if (depth > 0) {
                    result.append('$');
                    continue;
                }
                pos1 = Strings.resolve(value, result, pos1, pos2, properties) - 1;
                continue;
            }
            result.append(c1);
        }
        return result.toString();
    }

    private static int resolve(String value, StringBuilder result, int from, int to, Properties properties) {
        String key = Strings.resolvePlaceholders(value.substring(from + 2, to - 1), properties);
        String v = properties.getProperty(key);
        if (v == null) {
            result.append("${").append(key).append("}");
        } else {
            result.append(v);
        }
        return to;
    }
}

