/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.ConfigManager;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.keycloak.KeycloakServlet;
import io.hawt.web.auth.oidc.OidcConfiguration;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthConfigurationServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(KeycloakServlet.class);
    private OidcConfiguration oidcConfiguration = null;
    private boolean enabled = false;

    public void init() throws ServletException {
        ConfigManager configManager = (ConfigManager)this.getServletContext().getAttribute("ConfigManager");
        if (configManager == null) {
            throw new IllegalStateException("Hawtio config manager not found, cannot proceed Hawtio configuration");
        }
        AuthenticationConfiguration authConfig = AuthenticationConfiguration.getConfiguration(this.getServletContext());
        if (!authConfig.isEnabled()) {
            return;
        }
        this.oidcConfiguration = authConfig.getOidcConfiguration();
        this.enabled = this.oidcConfiguration != null && this.oidcConfiguration.isEnabled();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        if (path == null || path.trim().isEmpty() || "/".equals(path.trim())) {
            path = "/config";
        }
        if (path.equals("/config")) {
            if (!this.enabled) {
                ServletHelpers.sendJSONResponse(resp, "{}");
            } else {
                ServletHelpers.sendJSONResponse(resp, this.oidcConfiguration.toJSON());
            }
        } else if (path.equals("/session-timeout")) {
            String config = String.format("{\"req\":%s,\"now\":%d,\"timeout\":%d}", req.getParameter("t"), System.currentTimeMillis(), AuthSessionHelpers.getSessionTimeout(this.getServletContext()));
            ServletHelpers.sendJSONResponse(resp, config);
        } else {
            resp.setStatus(404);
        }
    }
}

