/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.ConfigManager;
import io.hawt.util.IOHelper;
import io.hawt.util.Strings;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthenticationContainerDiscovery;
import io.hawt.web.auth.AuthenticationThrottler;
import io.hawt.web.auth.oidc.OidcConfiguration;
import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.security.auth.login.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationConfiguration.class);
    public static final String LOGIN_URL = "/login";
    public static final String[] UNSECURED_PATHS = new String[]{"/login", "/auth/login", "/auth/logout", "/auth/config", "/auth/config/session-timeout", "/css", "/fonts", "/img", "/js", "/static", "/hawtconfig.json", "/jolokia", "/user", "/keycloak", "/plugin"};
    public static final String AUTHENTICATION_ENABLED = "authenticationEnabled";
    public static final String AUTH = "auth";
    public static final String AUTHENTICATION_THROTTLED = "authenticationThrottled";
    public static final String REALM = "realm";
    public static final String ROLES = "roles";
    public static final String ROLE_PRINCIPAL_CLASSES = "rolePrincipalClasses";
    public static final String NO_CREDENTIALS_401 = "noCredentials401";
    public static final String AUTHENTICATION_CONTAINER_DISCOVERY_CLASSES = "authenticationContainerDiscoveryClasses";
    public static final String KEYCLOAK_ENABLED = "keycloakEnabled";
    public static final String OIDC_CLIENT_CONFIG = "oidcConfig";
    public static final String HAWTIO_OIDC_CLIENT_CONFIG = "hawtio.oidcConfig";
    public static final String HAWTIO_AUTHENTICATION_ENABLED = "hawtio.authenticationEnabled";
    public static final String HAWTIO_AUTH = "hawtio.auth";
    public static final String HAWTIO_AUTHENTICATION_THROTTLED = "hawtio.authenticationThrottled";
    public static final String HAWTIO_REALM = "hawtio.realm";
    public static final String HAWTIO_ROLES = "hawtio.roles";
    public static final String HAWTIO_ROLE_PRINCIPAL_CLASSES = "hawtio.rolePrincipalClasses";
    public static final String HAWTIO_NO_CREDENTIALS_401 = "hawtio.noCredentials401";
    public static final String HAWTIO_AUTH_CONTAINER_DISCOVERY_CLASSES = "hawtio.authenticationContainerDiscoveryClasses";
    public static final String HAWTIO_KEYCLOAK_ENABLED = "hawtio.keycloakEnabled";
    public static final String AUTHENTICATION_CONFIGURATION = "authenticationConfig";
    public static final String DEFAULT_REALM = "hawtio";
    private static final String DEFAULT_KARAF_ROLES = "admin,manager,viewer";
    public static final String DEFAULT_KARAF_ROLE_PRINCIPAL_CLASSES = "org.apache.karaf.jaas.boot.principal.RolePrincipal,org.apache.karaf.jaas.modules.RolePrincipal,org.apache.karaf.jaas.boot.principal.GroupPrincipal";
    public static final String TOMCAT_AUTH_CONTAINER_DISCOVERY = "io.hawt.web.tomcat.TomcatAuthenticationContainerDiscovery";
    private final boolean enabled;
    private final Optional<AuthenticationThrottler> throttler;
    private final String realm;
    private final String roles;
    private String rolePrincipalClasses;
    private final boolean noCredentials401;
    private final boolean keycloakEnabled;
    private Configuration configuration;
    private final ConfigManager configManager;
    private OidcConfiguration oidcConfiguration;

    private AuthenticationConfiguration(ServletContext servletContext) {
        ConfigManager config = (ConfigManager)servletContext.getAttribute("ConfigManager");
        if (config == null) {
            throw new RuntimeException("Hawtio config manager not found, cannot proceed Hawtio configuration");
        }
        this.configManager = config;
        String auth = System.getProperty(HAWTIO_AUTH);
        if (auth != null) {
            System.setProperty(HAWTIO_AUTHENTICATION_ENABLED, auth);
        }
        this.enabled = config.getBoolean(AUTHENTICATION_ENABLED, true);
        boolean throttled = config.getBoolean(AUTHENTICATION_THROTTLED, true);
        LOG.info("Authentication throttling is {}", (Object)(throttled ? "enabled" : "disabled"));
        this.throttler = throttled ? Optional.of(new AuthenticationThrottler()) : Optional.empty();
        this.realm = config.get(REALM).orElse(DEFAULT_REALM);
        this.roles = config.get(ROLES).orElse(DEFAULT_KARAF_ROLES);
        String defaultRolePrincipalClasses = AuthenticationConfiguration.isKaraf() ? DEFAULT_KARAF_ROLE_PRINCIPAL_CLASSES : "";
        this.rolePrincipalClasses = config.get(ROLE_PRINCIPAL_CLASSES).orElse(defaultRolePrincipalClasses);
        this.noCredentials401 = config.getBoolean(NO_CREDENTIALS_401, false);
        boolean bl = this.keycloakEnabled = this.enabled && config.getBoolean(KEYCLOAK_ENABLED, false);
        if (this.enabled) {
            String authDiscoveryClasses = config.get(AUTHENTICATION_CONTAINER_DISCOVERY_CLASSES).orElse(TOMCAT_AUTH_CONTAINER_DISCOVERY);
            List<AuthenticationContainerDiscovery> discoveries = AuthenticationConfiguration.getDiscoveries(authDiscoveryClasses);
            for (AuthenticationContainerDiscovery discovery : discoveries) {
                if (!discovery.canAuthenticate(this)) continue;
                LOG.info("Discovered container {} to use with hawtio authentication filter", (Object)discovery.getContainerName());
                break;
            }
            LOG.info("Starting Hawtio authentication filter, JAAS realm: \"{}\" authorized role(s): \"{}\" role principal classes: \"{}\"", new Object[]{this.realm, this.roles, this.rolePrincipalClasses});
        } else {
            LOG.info("Starting hawtio authentication filter, JAAS authentication disabled");
        }
    }

    private static boolean isKaraf() {
        return System.getProperty("karaf.name") != null;
    }

    public static AuthenticationConfiguration getConfiguration(ServletContext servletContext) {
        AuthenticationConfiguration authConfig = (AuthenticationConfiguration)servletContext.getAttribute(AUTHENTICATION_CONFIGURATION);
        if (authConfig == null) {
            authConfig = new AuthenticationConfiguration(servletContext);
            servletContext.setAttribute(AUTHENTICATION_CONFIGURATION, (Object)authConfig);
        }
        return authConfig;
    }

    private static List<AuthenticationContainerDiscovery> getDiscoveries(String authDiscoveryClasses) {
        String[] discoveryClasses;
        ArrayList<AuthenticationContainerDiscovery> discoveries = new ArrayList<AuthenticationContainerDiscovery>();
        if (authDiscoveryClasses == null || authDiscoveryClasses.trim().isEmpty()) {
            return discoveries;
        }
        for (String discoveryClass : discoveryClasses = authDiscoveryClasses.split(",")) {
            try {
                Class<?> clazz = AuthenticationConfiguration.class.getClassLoader().loadClass(discoveryClass.trim());
                AuthenticationContainerDiscovery discovery = (AuthenticationContainerDiscovery)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                discoveries.add(discovery);
            }
            catch (Exception e) {
                LOG.warn("Couldn't instantiate discovery " + discoveryClass, (Throwable)e);
            }
        }
        return discoveries;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Optional<AuthenticationThrottler> getThrottler() {
        return this.throttler;
    }

    public boolean isNoCredentials401() {
        return this.noCredentials401;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getRoles() {
        return this.roles;
    }

    public String getRolePrincipalClasses() {
        return this.rolePrincipalClasses;
    }

    public void setRolePrincipalClasses(String rolePrincipalClasses) {
        this.rolePrincipalClasses = rolePrincipalClasses;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isKeycloakEnabled() {
        return this.keycloakEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureOidc() {
        InputStream is;
        String oidcConfigFile = this.configManager.get(OIDC_CLIENT_CONFIG).orElse(null);
        if (System.getProperty(HAWTIO_OIDC_CLIENT_CONFIG) != null) {
            oidcConfigFile = System.getProperty(HAWTIO_OIDC_CLIENT_CONFIG);
        }
        if (Strings.isBlank(oidcConfigFile)) {
            oidcConfigFile = this.defaultOidcConfigLocation();
        }
        if ((is = ServletHelpers.loadFile(oidcConfigFile)) != null) {
            LOG.info("Will load OIDC config from location: {}", (Object)oidcConfigFile);
            Properties props = new Properties();
            try {
                props.load(is);
                this.oidcConfiguration = new OidcConfiguration(props);
                this.oidcConfiguration.setRolePrincipalClasses(this.rolePrincipalClasses);
                if (this.oidcConfiguration.isEnabled()) {
                    this.configuration = this.oidcConfiguration;
                }
            }
            catch (IOException e) {
                LOG.warn("Couldn't read OIDC configuration file", (Throwable)e);
            }
            finally {
                IOHelper.close(is, "oidcInputStream", LOG);
            }
        }
    }

    protected String defaultOidcConfigLocation() {
        String karafBase = System.getProperty("karaf.base");
        if (karafBase != null) {
            return karafBase + "/etc/hawtio-oidc.properties";
        }
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null) {
            return jettyHome + "/etc/hawtio-oidc.properties";
        }
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome != null) {
            return tomcatHome + "/conf/hawtio-oidc.properties";
        }
        String jbossHome = System.getProperty("jboss.server.config.dir");
        if (jbossHome != null) {
            return jbossHome + "/hawtio-oidc.properties";
        }
        String artemisHome = System.getProperty("artemis.instance.etc");
        if (artemisHome != null) {
            return artemisHome + "/hawtio-oidc.properties";
        }
        return "classpath:hawtio-oidc.properties";
    }

    public OidcConfiguration getOidcConfiguration() {
        return this.oidcConfiguration;
    }

    public String toString() {
        return "AuthenticationConfiguration[enabled=" + this.enabled + ", noCredentials401=" + this.noCredentials401 + ", realm='" + this.realm + "', roles='" + this.roles + "', rolePrincipalClasses='" + this.rolePrincipalClasses + "', configuration=" + this.configuration + ", keycloakEnabled=" + this.keycloakEnabled + ", oidcEnabled=" + (this.oidcConfiguration != null && this.oidcConfiguration.isEnabled()) + "]";
    }
}

