/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.jmx;

import io.hawt.jmx.RBACRegistryMBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.util.EscapeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBACRegistry
implements RBACRegistryMBean {
    public static final Logger LOG = LoggerFactory.getLogger(RBACRegistry.class);
    private ObjectName rbacDecorator = null;
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    public void init() throws Exception {
        if (this.objectName == null) {
            this.objectName = new ObjectName("hawtio:type=security,name=RBACRegistry");
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            this.rbacDecorator = new ObjectName("hawtio:type=security,area=jolokia,name=RBACDecorator");
            try {
                this.mBeanServer.registerMBean(this, this.objectName);
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this, this.objectName);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.objectName != null && this.mBeanServer != null) {
            try {
                this.mBeanServer.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException e) {
                LOG.debug("Error unregistering mbean " + this.objectName + ". This exception is ignored.", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> list() throws Exception {
        return this.list(null);
    }

    @Override
    public Map<String, Object> list(String path) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Map<String, Object>> domains = new HashMap<String, Map<String, Object>>();
        HashMap<String, Map<String, Object>> cache = new HashMap<String, Map<String, Object>>();
        result.put("cache", cache);
        result.put("domains", domains);
        if (this.mBeanServer == null) {
            return result;
        }
        HashSet<ObjectName> visited = new HashSet<ObjectName>();
        ObjectName pathQuery = this.objectNameFromPath(path);
        for (ObjectName nameObject : this.mBeanServer.queryNames(pathQuery, null)) {
            this.addMBeanInfo(cache, domains, visited, nameObject);
        }
        this.tryAddRBACInfo(result);
        return result;
    }

    private ObjectName objectNameFromPath(String path) throws MalformedObjectNameException {
        if (path == null) {
            return null;
        }
        Stack pathStack = EscapeUtil.extractElementsFromPath((String)path);
        String domain = (String)pathStack.pop();
        if (pathStack.empty()) {
            return new ObjectName(domain + ":*");
        }
        String props = (String)pathStack.pop();
        ObjectName mbean = new ObjectName(domain + ":" + props);
        if (mbean.isPattern()) {
            throw new IllegalArgumentException("Cannot use an MBean pattern as path (given MBean: " + mbean + ")");
        }
        return mbean;
    }

    private void addMBeanInfo(Map<String, Map<String, Object>> cache, Map<String, Map<String, Object>> domains, Set<ObjectName> visited, ObjectName nameObject) throws IntrospectionException, ReflectionException {
        Map<String, Object> jsonifiedMBeanInfo;
        if (visited.contains(nameObject)) {
            return;
        }
        String mbeanInfoKey = this.isSpecialMBean(nameObject);
        if (mbeanInfoKey != null && cache.containsKey(mbeanInfoKey)) {
            jsonifiedMBeanInfo = cache.get(mbeanInfoKey);
        } else {
            try {
                MBeanInfo mBeanInfo = this.mBeanServer.getMBeanInfo(nameObject);
                if (mbeanInfoKey == null) {
                    mbeanInfoKey = this.isSpecialClass(nameObject, mBeanInfo);
                }
                jsonifiedMBeanInfo = mbeanInfoKey != null && cache.containsKey(mbeanInfoKey) ? cache.get(mbeanInfoKey) : this.jsonifyMBeanInfo(mBeanInfo);
                if (mbeanInfoKey != null) {
                    cache.put(mbeanInfoKey, jsonifiedMBeanInfo);
                }
            }
            catch (InstanceNotFoundException e) {
                LOG.debug("Failed to get MBean info for {}. Due to InstanceNotFoundException.", (Object)nameObject);
                return;
            }
        }
        Map domain = domains.computeIfAbsent(nameObject.getDomain(), key -> new HashMap());
        domain.put(nameObject.getKeyPropertyListString(), Objects.requireNonNullElse(mbeanInfoKey, jsonifiedMBeanInfo));
        visited.add(nameObject);
    }

    private Map<String, Object> jsonifyMBeanInfo(MBeanInfo mBeanInfo) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("desc", mBeanInfo.getDescription());
        LinkedHashMap attrMap = new LinkedHashMap();
        result.put("attr", attrMap);
        for (MBeanAttributeInfo attrInfo : mBeanInfo.getAttributes()) {
            if (attrInfo == null) continue;
            HashMap<String, Object> attr = new HashMap<String, Object>();
            attr.put("type", attrInfo.getType());
            attr.put("desc", attrInfo.getDescription());
            attr.put("rw", attrInfo.isWritable() && attrInfo.isReadable());
            attrMap.put(attrInfo.getName(), attr);
        }
        LinkedHashMap<String, Object> opMap = new LinkedHashMap<String, Object>();
        result.put("op", opMap);
        for (MBeanOperationInfo opInfo : mBeanInfo.getOperations()) {
            Map<String, Object> map = RBACRegistry.toMap(opInfo);
            Object ops = opMap.get(opInfo.getName());
            if (ops != null) {
                if (ops instanceof List) {
                    ((List)ops).add(map);
                    continue;
                }
                if (!(ops instanceof Map)) continue;
                LinkedList<Object> opList = new LinkedList<Object>();
                opList.add(ops);
                opList.add(map);
                opMap.put(opInfo.getName(), opList);
                continue;
            }
            opMap.put(opInfo.getName(), map);
        }
        LinkedHashMap notMap = new LinkedHashMap();
        result.put("not", notMap);
        for (MBeanNotificationInfo notInfo : mBeanInfo.getNotifications()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", notInfo.getName());
            map.put("desc", notInfo.getDescription());
            String[] types = notInfo.getNotifTypes();
            ArrayList tList = new ArrayList(types.length);
            Collections.addAll(tList, types);
            map.put("types", tList);
            notMap.put(notInfo.getName(), map);
        }
        result.put("canInvoke", true);
        return result;
    }

    private static Map<String, Object> toMap(MBeanOperationInfo opInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList argList = new ArrayList(opInfo.getSignature().length);
        for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("desc", paramInfo.getDescription());
            args.put("name", paramInfo.getName());
            args.put("type", paramInfo.getType());
            argList.add(args);
        }
        map.put("args", argList);
        map.put("ret", opInfo.getReturnType());
        map.put("desc", opInfo.getDescription());
        return map;
    }

    private String isSpecialMBean(ObjectName nameObject) {
        String domain;
        switch (domain = nameObject.getDomain()) {
            case "org.apache.activemq": {
                String destinationType = nameObject.getKeyProperty("destinationType");
                if ("Queue".equals(destinationType)) {
                    return "activemq:queue";
                }
                if ("TempQueue".equals(destinationType)) {
                    return "activemq:tempqueue";
                }
                if ("Topic".equals(destinationType)) {
                    return "activemq:topic";
                }
                if (!"TempTopic".equals(destinationType)) break;
                return "activemq:temptopic";
            }
            case "org.apache.activemq.artemis": {
                String component = nameObject.getKeyProperty("component");
                if (!"addresses".equals(component)) break;
                String subComponent = nameObject.getKeyProperty("subcomponent");
                if (subComponent == null) {
                    return "activemq.artemis:address";
                }
                if (!"queues".equals(subComponent)) break;
                return "activemq.artemis:queue";
            }
            case "org.apache.camel": {
                return null;
            }
        }
        return null;
    }

    private String isSpecialClass(ObjectName nameObject, MBeanInfo mBeanInfo) {
        String domain = nameObject.getDomain();
        if ("org.apache.camel".equals(domain) && mBeanInfo.getClassName() != null) {
            return "camel::" + mBeanInfo.getClassName();
        }
        return null;
    }

    private void tryAddRBACInfo(Map<String, Object> result) throws MBeanException, InstanceNotFoundException, ReflectionException {
        if (this.mBeanServer != null && this.mBeanServer.isRegistered(this.rbacDecorator)) {
            this.mBeanServer.invoke(this.rbacDecorator, "decorate", new Object[]{result}, new String[]{Map.class.getName()});
        }
    }
}

