/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web;

import io.hawt.util.IOHelper;
import io.hawt.web.ForbiddenReason;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.service.serializer.SerializeOptions;
import org.jolokia.service.serializer.JolokiaSerializer;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(ServletHelpers.class);
    protected static final String HEADER_HAWTIO_FORBIDDEN_REASON = "Hawtio-Forbidden-Reason";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_RETRY_AFTER = "Retry-After";
    private static final JolokiaSerializer SERIALIZER = new JolokiaSerializer();

    public static void doForbidden(HttpServletResponse response) {
        ServletHelpers.doForbidden(response, ForbiddenReason.NONE);
    }

    public static void doForbidden(HttpServletResponse response, ForbiddenReason reason) {
        try {
            response.setStatus(403);
            response.setHeader(HEADER_HAWTIO_FORBIDDEN_REASON, reason.name());
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send forbidden response: {}", (Object)ioe.toString());
        }
    }

    public static void doAuthPrompt(HttpServletResponse response, String realm) {
        try {
            response.setStatus(401);
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send auth response: {}", (Object)ioe.toString());
        }
    }

    public static void doTooManyRequests(HttpServletResponse response, long retryAfter) {
        try {
            response.setStatus(429);
            response.setHeader(HEADER_RETRY_AFTER, Long.toString(retryAfter));
            response.setContentLength(0);
            response.flushBuffer();
        }
        catch (IOException ioe) {
            LOG.debug("Failed to send throttling response: {}", (Object)ioe.toString());
        }
    }

    public static void sendJSONResponse(HttpServletResponse response, boolean value) throws IOException {
        ServletHelpers.sendJSONResponse(response, String.valueOf(value));
    }

    public static void sendJSONResponse(HttpServletResponse response, String json) throws IOException {
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.println(json);
        writer.flush();
        writer.close();
    }

    public static JSONObject readObject(BufferedReader reader) throws IOException {
        String data = IOHelper.readFully(reader);
        return new JSONObject(data);
    }

    public static void writeEmpty(PrintWriter out) {
        out.write("{}");
        out.flush();
        out.close();
    }

    public static void writeObjectAsJson(PrintWriter out, Object data) {
        Object result = null;
        try {
            result = SERIALIZER.serialize(data, null, SerializeOptions.DEFAULT);
        }
        catch (AttributeNotFoundException e) {
            LOG.warn("Failed to convert object to json", (Throwable)e);
        }
        if (result != null) {
            out.write(result.toString());
            out.flush();
            out.close();
        } else {
            ServletHelpers.writeEmpty(out);
        }
    }

    public static InputStream loadFile(String path) {
        if (((String)path).startsWith("classpath:")) {
            String classPathLocation = ((String)path).substring(10);
            InputStream is = ServletHelpers.class.getClassLoader().getResourceAsStream(classPathLocation);
            if (is != null) {
                return is;
            }
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(classPathLocation);
        }
        try {
            if (!((String)path).contains(":")) {
                path = "file://" + (String)path;
            }
            return new URL((String)path).openStream();
        }
        catch (Exception e) {
            LOG.debug("Couldn't find file: {}", path);
            return null;
        }
    }

    public static String sanitizeHeader(String header) {
        if (header == null) {
            return null;
        }
        return header.replaceAll("[\\r\\n]", "");
    }

    public static String cleanPath(String path) {
        String result = path.replaceAll("//+", "/");
        return result.length() == 1 && result.charAt(0) == '/' ? result : result.replaceAll("/+$", "");
    }

    public static String webContextPath(String first, String ... more) {
        if (more.length == 0 && (first == null || first.isEmpty())) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        if (first != null) {
            if (!first.startsWith("/")) {
                b.append('/');
            }
            b.append(first);
        }
        for (String s : more) {
            if (s == null || s.isEmpty()) continue;
            b.append('/');
            b.append(s);
        }
        String cleanedPath = ServletHelpers.cleanPath(b.toString());
        return cleanedPath.length() == 1 ? "" : cleanedPath;
    }

    public static int hawtioPathIndex(ServletContext servletContext) {
        String servletPath = (String)servletContext.getAttribute("hawtioServletPath");
        if (servletPath == null) {
            return 0;
        }
        String cleanPath = ServletHelpers.webContextPath(servletPath, new String[0]);
        int pathIndex = 0;
        for (char c : cleanPath.toCharArray()) {
            if (c != '/') continue;
            ++pathIndex;
        }
        return pathIndex;
    }
}

