/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseTagHrefFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(BaseTagHrefFilter.class);
    public static final String PARAM_APPLICATION_CONTEXT_PATH = "applicationContextPath";
    private static final String DEFAULT_CONTEXT_PATH = "/hawtio";
    private String applicationContextPath;
    private String basePath;

    public void init(FilterConfig filterConfig) throws ServletException {
        String path = filterConfig.getInitParameter(PARAM_APPLICATION_CONTEXT_PATH);
        this.applicationContextPath = path != null ? path : "";
        ServletContext context = filterConfig.getServletContext();
        String contextPath = context.getContextPath();
        this.basePath = contextPath == null || contextPath.isEmpty() ? (!this.applicationContextPath.startsWith("/") ? "/" : "") : contextPath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        String baseTagHref = this.basePath + this.applicationContextPath;
        LOG.debug("baseTagHref = {}", (Object)baseTagHref);
        if (baseTagHref.equals(DEFAULT_CONTEXT_PATH)) {
            filterChain.doFilter(request, response);
            return;
        }
        BaseTagHrefResponseWrapper responseWrapper = new BaseTagHrefResponseWrapper((HttpServletResponse)response);
        filterChain.doFilter(request, (ServletResponse)responseWrapper);
        if (response.isCommitted()) {
            return;
        }
        ServletOutputStream out = response.getOutputStream();
        String contentType = response.getContentType();
        byte[] content = responseWrapper.getData();
        if (contentType == null || !contentType.startsWith("text/html")) {
            out.write(content);
            return;
        }
        byte[] replacedContent = BaseTagHrefFilter.replaceHrefs(content, baseTagHref, (ServletResponse)responseWrapper);
        responseWrapper.setContentLength(replacedContent.length);
        out.write(replacedContent);
    }

    private static byte[] replaceHrefs(byte[] content, String href, ServletResponse response) throws UnsupportedEncodingException {
        if (!((String)href).endsWith("/")) {
            href = (String)href + "/";
        }
        String encoding = Optional.ofNullable(response.getCharacterEncoding()).orElse(StandardCharsets.UTF_8.name());
        String original = new String(content, encoding);
        String replaced = original.replaceAll(String.format("(src|href)=(['\"])%s/", DEFAULT_CONTEXT_PATH), String.format("$1=$2%s", href));
        LOG.trace("Original:\n{}", (Object)original);
        LOG.trace("Replaced:\n{}", (Object)replaced);
        return replaced.getBytes(encoding);
    }

    public void destroy() {
    }

    private static class BaseTagHrefResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream output = new ByteArrayOutputStream();

        public BaseTagHrefResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new FilterServletOutputStream(this.output);
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }
    }

    private static class FilterServletOutputStream
    extends ServletOutputStream {
        private final DataOutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }
    }
}

