/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Strings {
    public static String trimString(String value, int max) {
        if (value == null) {
            return "";
        }
        if (value.length() <= max) {
            return value;
        }
        return value.substring(0, max - 3) + "...";
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNotBlank(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String sanitize(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return name.replaceAll("[^0-9a-zA-Z\\+\\.\\(\\)_\\-]", "");
    }

    public static String sanitizeDirectory(String name) {
        if (Strings.isBlank(name)) {
            return name;
        }
        return Strings.sanitize(name).replace(".", "");
    }

    public static List<String> split(String text, String delimiter) {
        if (text == null || delimiter == null) {
            throw new IllegalArgumentException("Both 'text' and 'delimiter' should not be null.");
        }
        return Arrays.stream(text.split(delimiter)).map(s -> s.trim()).filter(s -> Strings.isNotBlank(s)).collect(Collectors.toList());
    }

    public static String cleanPath(String path) {
        String result = path.replaceAll("//+", "/");
        return result.length() == 1 && result.charAt(0) == '/' ? result : result.replaceAll("/+$", "");
    }

    public static String webContextPath(String first, String ... more) {
        if (more.length == 0 && (first == null || first.isEmpty())) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        if (first != null) {
            if (!first.startsWith("/")) {
                b.append('/');
            }
            b.append(first);
        }
        for (String s : more) {
            if (s == null || s.isEmpty()) continue;
            b.append('/');
            b.append(s);
        }
        String cleanedPath = Strings.cleanPath(b.toString());
        return cleanedPath.length() == 1 ? "" : cleanedPath;
    }
}

