/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.spring;

import io.fabric8.common.util.Objects;
import io.fabric8.watcher.spring.context.WatcherSpringContext;
import io.hawt.spring.WatcherSpringContextFacadeMXBean;
import io.hawt.util.MBeanSupport;
import java.io.File;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class WatcherSpringContextFacade
extends MBeanSupport
implements WatcherSpringContextFacadeMXBean {
    private File rootPath;
    private WatcherSpringContext watcher;
    private boolean manuallyCreatedWatcher;

    public void init() throws Exception {
        if (this.watcher == null) {
            if (this.rootPath != null) {
                this.rootPath.mkdirs();
            }
            this.watcher = new WatcherSpringContext();
            this.manuallyCreatedWatcher = true;
            this.watcher.setRootDirectory(this.rootPath);
            this.watcher.init();
        }
        super.init();
    }

    public void destroy() throws Exception {
        if (this.manuallyCreatedWatcher && this.watcher != null) {
            this.watcher.destroy();
        }
        super.destroy();
    }

    public WatcherSpringContext watcher() {
        Objects.notNull((Object)this.watcher, (String)"watcher");
        return this.watcher;
    }

    @Override
    public SortedSet<String> getLocations() {
        return this.watcher.getApplicationContextPaths();
    }

    @Override
    public Map<String, String[]> beanDefinitionNameMap() {
        TreeMap<String, String[]> answer = new TreeMap<String, String[]>();
        SortedSet paths = this.watcher.getApplicationContextPaths();
        for (String path : paths) {
            String[] beanNames;
            FileSystemXmlApplicationContext applicationContext = this.watcher.getApplicationContext(path);
            if (applicationContext == null || (beanNames = applicationContext.getBeanDefinitionNames()) == null) continue;
            answer.put(path, beanNames);
        }
        return answer;
    }

    @Override
    public Integer getBeanDefinitionCount() {
        int answer = 0;
        SortedSet paths = this.watcher.getApplicationContextPaths();
        for (String path : paths) {
            String[] beanNames;
            FileSystemXmlApplicationContext applicationContext = this.watcher.getApplicationContext(path);
            if (applicationContext == null || (beanNames = applicationContext.getBeanDefinitionNames()) == null) continue;
            answer += beanNames.length;
        }
        return answer;
    }

    public File getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(File rootPath) {
        this.rootPath = rootPath;
    }

    public WatcherSpringContext getWatcher() {
        return this.watcher;
    }

    public void setWatcher(WatcherSpringContext watcher) {
        this.watcher = watcher;
    }

    protected String getDefaultObjectName() {
        return "hawtio:type=WatcherFacade";
    }
}

