/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.ansi;

import io.helidon.build.common.logging.LogLevel;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import org.fusesource.jansi.Ansi;
import picocli.jansi.graalvm.AnsiConsole;

public class AnsiConsoleInstaller {
    public static final String HELIDON_CHILD_PROCESS_PROPERTY = "helidon.child.process";
    public static final boolean IS_HELIDON_CHILD_PROCESS = Boolean.getBoolean("helidon.child.process");
    private static final String JANSI_FORCE_PROPERTY = "jansi.force";
    private static final String JANSI_STRIP_PROPERTY = "jansi.strip";
    private static final String JANSI_PASS_THROUGH_PROPERTY = "jansi.passthrough";
    private static final String JANSI_PACKAGE_PREFIX = "org.fusesource.jansi";
    private static final String JANSI_STRIP_STREAM_CLASS_NAME = "org.fusesource.jansi.AnsiPrintStream";
    private static volatile boolean disabled;

    private AnsiConsoleInstaller() {
    }

    static boolean install() {
        return Holder.INSTANCE.enabled;
    }

    public static void disable() {
        disabled = true;
        if (Holder.INSTANCE.enabled) {
            throw new IllegalStateException("Color support is already enabled");
        }
    }

    public static String childProcessArgument() {
        return Holder.INSTANCE.consoleType.childProcessArgument();
    }

    public static boolean areAnsiEscapesEnabled() {
        return Holder.INSTANCE.enabled;
    }

    private static final class Holder {
        private static final Holder INSTANCE = new Holder();
        private final ConsoleType consoleType;
        private final boolean enabled;

        private Holder() {
            if (disabled) {
                this.consoleType = ConsoleType.DEFAULT;
                this.enabled = false;
                System.setProperty(AnsiConsoleInstaller.JANSI_STRIP_PROPERTY, "true");
                Ansi.setEnabled((boolean)false);
            } else {
                ConsoleType desiredType = Holder.desiredConsoleType();
                AnsiConsole.systemInstall();
                this.consoleType = Holder.installedConsoleType(desiredType);
                this.enabled = this.consoleType == ConsoleType.ANSI || this.consoleType == ConsoleType.DEFAULT;
            }
        }

        private static ConsoleType desiredConsoleType() {
            if (Boolean.getBoolean(AnsiConsoleInstaller.JANSI_FORCE_PROPERTY)) {
                Holder.log("Jansi streams requested: %s=true", AnsiConsoleInstaller.JANSI_FORCE_PROPERTY);
                return ConsoleType.ANSI;
            }
            if (Boolean.getBoolean(AnsiConsoleInstaller.JANSI_STRIP_PROPERTY)) {
                Holder.log("Jansi strip streams requested: %s=true", AnsiConsoleInstaller.JANSI_STRIP_PROPERTY);
                return ConsoleType.STRIP_ANSI;
            }
            if (Boolean.getBoolean(AnsiConsoleInstaller.JANSI_PASS_THROUGH_PROPERTY)) {
                Holder.log("Jansi pass through streams requested: %s=true", AnsiConsoleInstaller.JANSI_PASS_THROUGH_PROPERTY);
                return ConsoleType.STRIP_ANSI;
            }
            if (System.console() != null) {
                Holder.log("No Jansi request, but Console is available", new Object[0]);
                return ConsoleType.ANSI;
            }
            Holder.log("No Jansi request and Console is not available", new Object[0]);
            return ConsoleType.DEFAULT;
        }

        private static ConsoleType installedConsoleType(ConsoleType desiredType) {
            ConsoleType installedType;
            String systemOutClassName;
            block14: {
                PrintStream systemOut = System.out;
                Class<?> systemOutclass = systemOut.getClass();
                systemOutClassName = systemOutclass.getName();
                if (systemOutClassName.startsWith(AnsiConsoleInstaller.JANSI_PACKAGE_PREFIX)) {
                    if (systemOutClassName.equals(AnsiConsoleInstaller.JANSI_STRIP_STREAM_CLASS_NAME)) {
                        try {
                            String mode = systemOutclass.getMethod("getMode", new Class[0]).invoke((Object)systemOut, new Object[0]).toString();
                            if (mode.equalsIgnoreCase("strip")) {
                                installedType = ConsoleType.STRIP_ANSI;
                                break block14;
                            }
                            if (mode.equalsIgnoreCase("force")) {
                                installedType = ConsoleType.ANSI;
                                break block14;
                            }
                            installedType = ConsoleType.DEFAULT;
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                            installedType = ConsoleType.STRIP_ANSI;
                        }
                    } else {
                        installedType = ConsoleType.ANSI;
                    }
                } else {
                    installedType = ConsoleType.DEFAULT;
                }
            }
            if (desiredType != installedType) {
                switch (installedType) {
                    case STRIP_ANSI: {
                        Holder.log("Desired = %s, but Ansi escapes will be stripped by system streams.", new Object[]{desiredType});
                        break;
                    }
                    case ANSI: {
                        Holder.log("Desired = %s, but Ansi escapes should be supported by system streams.", new Object[]{desiredType});
                        break;
                    }
                    case DEFAULT: {
                        Holder.log("Desired = %s, but System.out not a Jansi type (%s) so Ansi escapes should not be stripped", new Object[]{desiredType, systemOutClassName});
                        break;
                    }
                }
            }
            return installedType;
        }

        private static void log(String message, Object ... args) {
            if (LogLevel.isDebug()) {
                System.out.printf(message + "%n", args);
            }
        }
    }

    private static enum ConsoleType {
        ANSI("jansi.force"),
        STRIP_ANSI("jansi.strip"),
        DEFAULT("jansi.passthrough");

        private final String argument;

        private ConsoleType(String propertyName) {
            this.argument = "-Dhelidon.child.process=true -D" + propertyName + "=true";
        }

        public String childProcessArgument() {
            return this.argument;
        }
    }
}

