/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.ansi;

import io.helidon.build.common.PrintStreams;
import io.helidon.build.common.ansi.AnsiConsoleInstaller;
import org.fusesource.jansi.Ansi;

public class ConsoleUtils {
    private static final char FIRST_ESC_CHAR = '\u001b';
    private static final char SECOND_ESC_CHAR = '[';
    private static final char[] SHOW_CURSOR = new char[]{'\u001b', '[', '?', '2', '5', 'h'};
    private static final char[] HIDE_CURSOR = new char[]{'\u001b', '[', '?', '2', '5', 'l'};

    private ConsoleUtils() {
    }

    public static boolean clearScreen() {
        return ConsoleUtils.clearScreen(0);
    }

    public static boolean clearScreen(int startRow) {
        if (AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
            PrintStreams.STDOUT.print(Ansi.ansi().cursor(startRow, 0).eraseScreen());
            PrintStreams.STDOUT.flush();
            return true;
        }
        return false;
    }

    public static boolean rewriteLine(String message) {
        return ConsoleUtils.rewriteLine(message.length(), message);
    }

    public static boolean rewriteLine(int charsToBackUp, String message) {
        if (AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
            PrintStreams.STDOUT.print(Ansi.ansi().cursorLeft(charsToBackUp).a(message));
            PrintStreams.STDOUT.flush();
            return true;
        }
        return false;
    }

    public static boolean hideCursor() {
        if (AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
            PrintStreams.STDOUT.print(HIDE_CURSOR);
            PrintStreams.STDOUT.flush();
            return true;
        }
        return false;
    }

    public static boolean showCursor() {
        if (AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
            PrintStreams.STDOUT.print(SHOW_CURSOR);
            PrintStreams.STDOUT.flush();
            return true;
        }
        return false;
    }

    public static void reset() {
        if (AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
            PrintStreams.STDOUT.println(Ansi.ansi().reset().toString());
            PrintStreams.STDOUT.flush();
        }
    }
}

