/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.ansi;

import io.helidon.build.common.RichText;
import io.helidon.build.common.RichTextStyle;
import io.helidon.build.common.ansi.AnsiText;
import io.helidon.build.common.ansi.AnsiTextProvider;
import io.helidon.build.common.logging.Log;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.fusesource.jansi.Ansi;

public class AnsiTextStyle
implements RichTextStyle {
    private static final boolean ANSI_ENABLED = AnsiTextProvider.isEnabled();
    private static final AnsiTextStyle NONE = new AnsiTextStyle();
    private static final AnsiTextStyle PLAIN = new Emphasis(Ansi.Attribute.RESET);
    private static final AnsiTextStyle BOLD = new Emphasis(Ansi.Attribute.INTENSITY_BOLD);
    private static final AnsiTextStyle ITALIC = new Emphasis(Ansi.Attribute.ITALIC);
    private static final AnsiTextStyle FAINT = new Emphasis(Ansi.Attribute.INTENSITY_FAINT);
    private static final RichTextStyle.StyleList BOLD_ITALIC = new RichTextStyle.StyleList(new RichTextStyle[]{BOLD}).add((RichTextStyle)ITALIC);
    private static final AnsiTextStyle NEGATIVE = new Emphasis(Ansi.Attribute.NEGATIVE_ON);
    private static final Map<String, RichTextStyle> STYLES = AnsiTextStyle.stylesByName();
    private static final char ESC_CH1 = '\u001b';
    private static final char ESC_CH2 = '[';
    private static final char CMD_CH2 = ']';
    private static final char BEL = '\u0007';
    private static final char ST_CH2 = '\\';
    private static final char CHARSET0_CH2 = '(';
    private static final char CHARSET1_CH2 = ')';
    private static final String ANSI_ESCAPE_BEGIN = "\u001b[";

    public static Map<String, RichTextStyle> styles() {
        return STYLES;
    }

    public static AnsiTextStyle none() {
        return NONE;
    }

    public static RichTextStyle named(String name) {
        return AnsiTextStyle.named(name, false);
    }

    public static RichTextStyle named(String name, boolean required) {
        RichTextStyle style = STYLES.get(name);
        if (style == null) {
            if (required) {
                throw new IllegalArgumentException("Unknown style: " + name);
            }
            return NONE;
        }
        return ANSI_ENABLED ? style : NONE;
    }

    public static List<String> colorNames() {
        return List.of("red", "yellow", "green", "cyan", "blue", "magenta", "white", "black", "default", "bold", "negative");
    }

    public static List<String> backgroundColorNames() {
        return List.of("bg_red", "bg_yellow", "bg_green", "bg_cyan", "bg_blue", "bg_magenta", "bg_white", "bg_black", "bg_default", "bg_negative");
    }

    public static List<String> emphasisNames() {
        return List.of("italic", "bold", "faint", "plain", "underline", "strikethrough", "negative", "conceal", "blink");
    }

    public static AnsiTextStyle of(Ansi.Color color, boolean background, boolean bright) {
        return new Hue(color, background, bright);
    }

    public static RichTextStyle of(Ansi.Attribute ... attributes) {
        if (attributes.length == 0) {
            return NONE;
        }
        if (attributes.length == 1) {
            return new Emphasis(attributes[0]);
        }
        return new RichTextStyle.StyleList(Emphasis::new, (Object[])attributes);
    }

    public static boolean isStyled(String text) {
        return text != null && text.contains(ANSI_ESCAPE_BEGIN);
    }

    public static String strip(String input) {
        AnsiState state = AnsiState.ESC1;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        int pos = 0;
        for (int index = 0; index < input.length(); ++index) {
            char c = input.charAt(index);
            switch (state) {
                case ESC1: {
                    if (c == '\u001b') {
                        buffer[pos++] = c;
                        state = AnsiState.ESC2;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case ESC2: {
                    buffer[pos++] = c;
                    if (c == '[') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    if (c == ']') {
                        state = AnsiState.CMD;
                        break;
                    }
                    if (c == '(') {
                        state = AnsiState.CHARSET;
                        break;
                    }
                    if (c == ')') {
                        state = AnsiState.CHARSET;
                        break;
                    }
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case NEXT_ARG: {
                    buffer[pos++] = c;
                    if ('\"' == c) {
                        state = AnsiState.STR_ARG_END;
                        break;
                    }
                    if ('0' <= c && c <= '9') {
                        state = AnsiState.INT_ARG_END;
                        break;
                    }
                    if (c == ';' || c == '?' || c == '=') break;
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case INT_ARG_END: {
                    buffer[pos++] = c;
                    if ('0' <= c && c <= '9') break;
                    if (c == ';') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case STR_ARG_END: {
                    buffer[pos++] = c;
                    if ('\"' == c) break;
                    if (c == ';') {
                        state = AnsiState.NEXT_ARG;
                        break;
                    }
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD: {
                    buffer[pos++] = c;
                    if ('0' <= c && c <= '9') {
                        state = AnsiState.CMD_END;
                        break;
                    }
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD_END: {
                    buffer[pos++] = c;
                    if (';' == c) {
                        state = AnsiState.CMD_PARAM;
                        break;
                    }
                    if ('0' <= c && c <= '9') break;
                    sb.append(buffer, 0, pos);
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
                case CMD_PARAM: {
                    buffer[pos++] = c;
                    if ('\u0007' == c) {
                        pos = 0;
                        state = AnsiState.ESC1;
                        break;
                    }
                    if ('\u001b' != c) break;
                    state = AnsiState.ST;
                    break;
                }
                case ST: {
                    buffer[pos++] = c;
                    if ('\\' == c) {
                        pos = 0;
                        state = AnsiState.ESC1;
                        break;
                    }
                    state = AnsiState.CMD_PARAM;
                    break;
                }
                case CHARSET: {
                    pos = 0;
                    state = AnsiState.ESC1;
                    break;
                }
            }
            if (index < buffer.length) continue;
            sb.append(buffer, 0, pos);
            pos = 0;
            state = AnsiState.ESC1;
        }
        return sb.toString();
    }

    public static void main(String ... args) {
        boolean list = false;
        if (args.length == 1) {
            if (args[0].equals("--list")) {
                list = true;
            } else if (!args[0].equals("--table")) {
                throw new IllegalArgumentException("Unknown argument: " + args[0]);
            }
        }
        if (list) {
            AnsiTextStyle.styles().forEach((name, style) -> Log.info((String)"%14s [ %s ]", (Object[])new Object[]{name, style.apply((Object)"example")}));
        } else {
            AnsiTextStyle.logSummaryTables();
        }
    }

    public static void logSummaryTables() {
        Log.info();
        AnsiTextStyle.logTextSummaryTable();
        Log.info();
        AnsiTextStyle.logBackgroundSummaryTable();
        Log.info();
    }

    public static void logTextSummaryTable() {
        AnsiTextStyle.logTable(AnsiTextStyle.colorNames(), false);
    }

    public static void logBackgroundSummaryTable() {
        AnsiTextStyle.logTable(AnsiTextStyle.backgroundColorNames(), true);
    }

    private static void logTable(List<String> names, boolean background) {
        String header = background ? "Background Color" : "Text Color";
        String example = " Example 1234 !@#$% ";
        String rowFormat = "\u2502 %-19s\u2502 %22s \u2502 %22s \u2502 %22s \u2502 %22s \u2502";
        Log.info((String)"\u250c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u252c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2510", (Object[])new Object[0]);
        Log.info((String)"\u2502 %-19s\u2502        Plain         \u2502        Italic        \u2502         Bold         \u2502    Italic & Bold     \u2502", (Object[])new Object[]{header});
        Log.info((String)"\u251c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u253c\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2524", (Object[])new Object[0]);
        names.forEach(name -> {
            String textColor = background ? "default" : name;
            String backgroundColor = background ? name : "bg_default";
            Object textColorBright = background ? textColor : textColor + "!";
            Object backgroundColorBright = background ? backgroundColor + "!" : backgroundColor;
            String plain = RichTextStyle.of((String[])new String[]{backgroundColor, textColor}).apply((Object)example);
            String italic = RichTextStyle.of((String[])new String[]{backgroundColor, textColor, "italic"}).apply((Object)example);
            String bold = RichTextStyle.of((String[])new String[]{backgroundColor, textColor, "bold"}).apply((Object)example);
            String italicBold = RichTextStyle.of((String[])new String[]{backgroundColor, textColor, "ITALIC"}).apply((Object)example);
            String plainBright = RichTextStyle.of((String[])new String[]{backgroundColorBright, textColorBright}).apply((Object)example);
            String italicBright = RichTextStyle.of((String[])new String[]{backgroundColorBright, textColorBright, "italic"}).apply((Object)example);
            String boldBright = RichTextStyle.of((String[])new String[]{backgroundColorBright, textColorBright, "bold"}).apply((Object)example);
            String italicBoldBright = RichTextStyle.of((String[])new String[]{backgroundColorBright, textColorBright, "ITALIC"}).apply((Object)example);
            Log.info((String)rowFormat, (Object[])new Object[]{name, plain, italic, bold, italicBold});
            Log.info((String)rowFormat, (Object[])new Object[]{name + "!", plainBright, italicBright, boldBright, italicBoldBright});
        });
        Log.info((String)"\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2534\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2518", (Object[])new Object[0]);
    }

    public String toString() {
        return "none";
    }

    public RichText apply(RichText richText) {
        return richText;
    }

    public RichText reset(RichText richText) {
        return richText;
    }

    private static Map<String, RichTextStyle> stylesByName() {
        LinkedHashMap<String, RichTextStyle> styles = new LinkedHashMap<String, RichTextStyle>();
        styles.put("none", AnsiTextStyle.none());
        styles.put("bg_none", AnsiTextStyle.none());
        AnsiTextStyle.colorNames().stream().filter(name -> !name.equals("bold")).forEach(lowerName -> {
            boolean negative = lowerName.equals("negative");
            String upperName = lowerName.toUpperCase(Locale.ENGLISH);
            Ansi.Color color = negative ? null : Ansi.Color.valueOf((String)upperName);
            AnsiTextStyle basic = negative ? NEGATIVE : AnsiTextStyle.of(color, false, false);
            AnsiTextStyle bright = negative ? NEGATIVE : AnsiTextStyle.of(color, false, true);
            RichTextStyle bold = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{BOLD, basic});
            RichTextStyle italic = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{ITALIC, basic});
            RichTextStyle italicBold = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{BOLD_ITALIC, basic});
            RichTextStyle boldBright = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{BOLD, bright});
            RichTextStyle italicBright = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{bright, ITALIC});
            RichTextStyle italicBoldBright = RichTextStyle.of((RichTextStyle[])new RichTextStyle[]{BOLD, ITALIC, bright});
            styles.put((String)lowerName, basic);
            styles.put("*" + lowerName + "*", italic);
            styles.put("_" + lowerName + "_", italic);
            styles.put("**" + lowerName + "**", bold);
            styles.put("__" + lowerName + "__", bold);
            styles.put(upperName, bold);
            styles.put("**_" + lowerName + "_**", italicBold);
            styles.put("__*" + lowerName + "*__", italicBold);
            styles.put("_" + upperName + "_", italicBold);
            styles.put("*" + upperName + "*", italicBold);
            styles.put(lowerName + "!", bright);
            styles.put("*" + lowerName + "*!", italicBright);
            styles.put("_" + lowerName + "_!", italicBright);
            styles.put("**" + lowerName + "**!", boldBright);
            styles.put("__" + lowerName + "__!", boldBright);
            styles.put(upperName + "!", boldBright);
            styles.put("**_" + lowerName + "_**!", italicBoldBright);
            styles.put("__*" + lowerName + "*__!", italicBoldBright);
            styles.put("_" + upperName + "_!", italicBoldBright);
            styles.put("*" + upperName + "*!", italicBoldBright);
            styles.put("bg_" + lowerName, negative ? NEGATIVE : AnsiTextStyle.of(color, true, false));
            styles.put("bg_" + lowerName + "!", negative ? NEGATIVE : AnsiTextStyle.of(color, true, true));
        });
        styles.put("bold", BOLD);
        styles.put("BOLD", BOLD);
        styles.put("italic", ITALIC);
        styles.put("*bold*", (RichTextStyle)BOLD_ITALIC);
        styles.put("_bold_", (RichTextStyle)BOLD_ITALIC);
        styles.put("*BOLD*", (RichTextStyle)BOLD_ITALIC);
        styles.put("_BOLD_", (RichTextStyle)BOLD_ITALIC);
        styles.put("**italic**", (RichTextStyle)BOLD_ITALIC);
        styles.put("__italic__", (RichTextStyle)BOLD_ITALIC);
        styles.put("ITALIC", (RichTextStyle)BOLD_ITALIC);
        styles.put("plain", PLAIN);
        styles.put("faint", FAINT);
        styles.put("underline", AnsiTextStyle.of(Ansi.Attribute.UNDERLINE));
        styles.put("strikethrough", AnsiTextStyle.of(Ansi.Attribute.STRIKETHROUGH_ON));
        styles.put("blink", AnsiTextStyle.of(Ansi.Attribute.BLINK_SLOW));
        styles.put("conceal", AnsiTextStyle.of(Ansi.Attribute.CONCEAL_ON));
        return styles;
    }

    static class Hue
    extends AnsiTextStyle {
        private final Ansi.Color color;
        private final boolean background;
        private final boolean bright;

        Hue(Ansi.Color color, boolean background, boolean bright) {
            this.color = Objects.requireNonNull(color);
            this.background = background;
            this.bright = bright;
        }

        @Override
        public RichText apply(RichText richText) {
            Ansi ansi = ((AnsiText)richText).ansi();
            if (this.background) {
                if (this.bright) {
                    ansi.bgBright(this.color);
                } else {
                    ansi.bg(this.color);
                }
            } else if (this.bright) {
                ansi.fgBright(this.color);
            } else {
                ansi.fg(this.color);
            }
            return richText;
        }

        @Override
        public RichText reset(RichText richText) {
            return richText.reset();
        }

        @Override
        public String toString() {
            return this.color + ", background=" + this.background + ", bright=" + this.bright;
        }
    }

    static class Emphasis
    extends AnsiTextStyle {
        private final Ansi.Attribute attribute;

        Emphasis(Ansi.Attribute attribute) {
            this.attribute = Objects.requireNonNull(attribute);
        }

        @Override
        public RichText apply(RichText richText) {
            Ansi ansi = ((AnsiText)richText).ansi();
            ansi.a(this.attribute);
            return richText;
        }

        @Override
        public RichText reset(RichText ansi) {
            return ansi.reset();
        }

        @Override
        public String toString() {
            return this.attribute.toString();
        }
    }

    private static enum AnsiState {
        ESC1,
        ESC2,
        NEXT_ARG,
        STR_ARG_END,
        INT_ARG_END,
        CMD,
        CMD_END,
        CMD_PARAM,
        ST,
        CHARSET;

    }
}

