/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven.plugin;

import io.helidon.build.common.Lists;
import io.helidon.build.common.SourcePath;
import io.helidon.build.common.maven.MavenModel;
import io.helidon.build.common.maven.plugin.MavenArtifact;
import io.helidon.build.common.maven.plugin.MavenPattern;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public final class MavenFilters {
    private MavenFilters() {
    }

    public static Predicate<Path> dirFilter(List<String> paths) {
        return dir -> {
            if (!Files.isDirectory(dir, new LinkOption[0])) return false;
            if (!paths.stream().map(dir::resolve).allMatch(x$0 -> Files.exists(x$0, new LinkOption[0]))) return false;
            return true;
        };
    }

    public static Predicate<Path> pathFilter(List<String> includes, List<String> excludes, Path dir) {
        return MavenFilters.filter(includes, excludes, Function.identity(), p -> new SourcePath(dir, p), SourcePath::matches);
    }

    public static Predicate<String> stringFilter(List<String> includes, List<String> excludes) {
        return MavenFilters.filter(includes, excludes, Function.identity(), Function.identity(), SourcePath::wildcardMatch);
    }

    public static Predicate<MavenArtifact> artifactFilter(List<String> includes, List<String> excludes) {
        return MavenFilters.filter(includes, excludes, MavenPattern::create, Function.identity(), (a, p) -> p.matches((MavenArtifact)a));
    }

    public static Predicate<MavenModel> pomFilter(List<String> includes, List<String> excludes) {
        return MavenFilters.filter(includes, excludes, MavenPattern::create, Function.identity(), (a, p) -> p.matches((MavenModel)a));
    }

    public static <T, U, V> Predicate<U> filter(List<String> includes, List<String> excludes, Function<String, T> patternFactory, Function<U, V> mapper, BiFunction<V, T, Boolean> predicate) {
        List includePatterns = Lists.map(includes, patternFactory);
        List excludePatterns = Lists.map(excludes, patternFactory);
        return u -> {
            Object v = mapper.apply(u);
            return includePatterns.stream().anyMatch(it -> (Boolean)predicate.apply(v, it)) && excludePatterns.stream().noneMatch(it -> (Boolean)predicate.apply(v, it));
        };
    }
}

