/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.common.maven.plugin;

import io.helidon.build.common.SourcePath;
import io.helidon.build.common.maven.MavenModel;
import io.helidon.build.common.maven.plugin.MavenArtifact;

public record MavenPattern(String groupId, String artifactId, String classifier, String type) {
    public static MavenPattern create(String filter) {
        int i;
        String[] args = new String[4];
        int index = 0;
        for (i = 0; i < 4; ++i) {
            if (index >= 0) {
                int endIndex = filter.indexOf(58, index);
                if (index == endIndex + 1 || index == endIndex) break;
                if (endIndex > 0) {
                    args[i] = filter.substring(index, endIndex);
                    int nextIndex = endIndex + 1;
                    if (nextIndex == filter.length()) break;
                    index = nextIndex;
                    continue;
                }
                args[i] = filter.substring(index);
                index = -1;
                continue;
            }
            args[i] = "*";
        }
        if (i > 0 && index == -1) {
            return new MavenPattern(args[0], args[1], args[2], args[3]);
        }
        throw new IllegalArgumentException("Invalid filter at index %d: %s".formatted(i > 0 ? index : 0, filter));
    }

    public boolean matches(MavenArtifact artifact) {
        return this.matches(artifact.groupId(), artifact.artifactId(), artifact.classifier(), artifact.type());
    }

    public boolean matches(MavenModel pom) {
        return this.matches(pom.groupId(), pom.artifactId(), "", pom.packaging());
    }

    public boolean matches(String groupId, String artifactId, String classifier, String type) {
        return SourcePath.wildcardMatch((String)groupId, (String)this.groupId) && SourcePath.wildcardMatch((String)artifactId, (String)this.artifactId) && SourcePath.wildcardMatch((String)(classifier != null ? classifier : ""), (String)this.classifier) && SourcePath.wildcardMatch((String)type, (String)this.type);
    }
}

